package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{GroupingValue, GroupingCriteria}
import scala.jdk.CollectionConverters.*
final case class GroupingConfiguration(
    criteria: Optional[GroupingCriteria] = Optional.Absent,
    values: Optional[Iterable[GroupingValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GroupingConfiguration = {
    import GroupingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GroupingConfiguration
      .builder()
      .optionallyWith(
        criteria.map(value => GroupingCriteria.unwrap(value): java.lang.String)
      )(_.criteria)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            GroupingValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GroupingConfiguration.ReadOnly =
    zio.aws.wisdom.model.GroupingConfiguration.wrap(buildAwsValue())
}
object GroupingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GroupingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GroupingConfiguration =
      zio.aws.wisdom.model.GroupingConfiguration(
        criteria.map(value => value),
        values.map(value => value)
      )
    def criteria: Optional[GroupingCriteria]
    def values: Optional[List[GroupingValue]]
    def getCriteria: ZIO[Any, AwsError, GroupingCriteria] =
      AwsError.unwrapOptionField("criteria", criteria)
    def getValues: ZIO[Any, AwsError, List[GroupingValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GroupingConfiguration
  ) extends zio.aws.wisdom.model.GroupingConfiguration.ReadOnly {
    override val criteria: Optional[GroupingCriteria] = zio.aws.core.internal
      .optionalFromNullable(impl.criteria())
      .map(value => zio.aws.wisdom.model.primitives.GroupingCriteria(value))
    override val values: Optional[List[GroupingValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.primitives.GroupingValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GroupingConfiguration
  ): zio.aws.wisdom.model.GroupingConfiguration.ReadOnly = new Wrapper(impl)
}
