package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  UploadId,
  SyntheticTimestamp_epoch_seconds,
  Url,
  Arn,
  Uuid,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ImportJobData(
    createdTime: SyntheticTimestamp_epoch_seconds,
    externalSourceConfiguration: Optional[
      zio.aws.wisdom.model.ExternalSourceConfiguration
    ] = Optional.Absent,
    failedRecordReport: Optional[Url] = Optional.Absent,
    importJobId: Uuid,
    importJobType: zio.aws.wisdom.model.ImportJobType,
    knowledgeBaseArn: Arn,
    knowledgeBaseId: Uuid,
    lastModifiedTime: SyntheticTimestamp_epoch_seconds,
    metadata: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    status: zio.aws.wisdom.model.ImportJobStatus,
    uploadId: UploadId,
    url: Url,
    urlExpiry: SyntheticTimestamp_epoch_seconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ImportJobData = {
    import ImportJobData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ImportJobData
      .builder()
      .createdTime(
        SyntheticTimestamp_epoch_seconds.unwrap(createdTime): Instant
      )
      .optionallyWith(
        externalSourceConfiguration.map(value => value.buildAwsValue())
      )(_.externalSourceConfiguration)
      .optionallyWith(
        failedRecordReport.map(value => Url.unwrap(value): java.lang.String)
      )(_.failedRecordReport)
      .importJobId(Uuid.unwrap(importJobId): java.lang.String)
      .importJobType(importJobType.unwrap)
      .knowledgeBaseArn(Arn.unwrap(knowledgeBaseArn): java.lang.String)
      .knowledgeBaseId(Uuid.unwrap(knowledgeBaseId): java.lang.String)
      .lastModifiedTime(
        SyntheticTimestamp_epoch_seconds.unwrap(lastModifiedTime): Instant
      )
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .status(status.unwrap)
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .url(Url.unwrap(url): java.lang.String)
      .urlExpiry(SyntheticTimestamp_epoch_seconds.unwrap(urlExpiry): Instant)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ImportJobData.ReadOnly =
    zio.aws.wisdom.model.ImportJobData.wrap(buildAwsValue())
}
object ImportJobData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ImportJobData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ImportJobData =
      zio.aws.wisdom.model.ImportJobData(
        createdTime,
        externalSourceConfiguration.map(value => value.asEditable),
        failedRecordReport.map(value => value),
        importJobId,
        importJobType,
        knowledgeBaseArn,
        knowledgeBaseId,
        lastModifiedTime,
        metadata.map(value => value),
        status,
        uploadId,
        url,
        urlExpiry
      )
    def createdTime: SyntheticTimestamp_epoch_seconds
    def externalSourceConfiguration
        : Optional[zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly]
    def failedRecordReport: Optional[Url]
    def importJobId: Uuid
    def importJobType: zio.aws.wisdom.model.ImportJobType
    def knowledgeBaseArn: Arn
    def knowledgeBaseId: Uuid
    def lastModifiedTime: SyntheticTimestamp_epoch_seconds
    def metadata: Optional[Map[NonEmptyString, NonEmptyString]]
    def status: zio.aws.wisdom.model.ImportJobStatus
    def uploadId: UploadId
    def url: Url
    def urlExpiry: SyntheticTimestamp_epoch_seconds
    def getCreatedTime: ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(createdTime)
    def getExternalSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalSourceConfiguration",
      externalSourceConfiguration
    )
    def getFailedRecordReport: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("failedRecordReport", failedRecordReport)
    def getImportJobId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(importJobId)
    def getImportJobType
        : ZIO[Any, Nothing, zio.aws.wisdom.model.ImportJobType] =
      ZIO.succeed(importJobType)
    def getKnowledgeBaseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(knowledgeBaseId)
    def getLastModifiedTime
        : ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(lastModifiedTime)
    def getMetadata: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.ImportJobStatus] =
      ZIO.succeed(status)
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
    def getUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(url)
    def getUrlExpiry: ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(urlExpiry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ImportJobData
  ) extends zio.aws.wisdom.model.ImportJobData.ReadOnly {
    override val createdTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.createdTime())
    override val externalSourceConfiguration
        : Optional[zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalSourceConfiguration())
        .map(value =>
          zio.aws.wisdom.model.ExternalSourceConfiguration.wrap(value)
        )
    override val failedRecordReport: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.failedRecordReport())
      .map(value => zio.aws.wisdom.model.primitives.Url(value))
    override val importJobId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.importJobId())
    override val importJobType: zio.aws.wisdom.model.ImportJobType =
      zio.aws.wisdom.model.ImportJobType.wrap(impl.importJobType())
    override val knowledgeBaseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.knowledgeBaseArn())
    override val knowledgeBaseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.knowledgeBaseId())
    override val lastModifiedTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.lastModifiedTime())
    override val metadata: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.wisdom.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.wisdom.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val status: zio.aws.wisdom.model.ImportJobStatus =
      zio.aws.wisdom.model.ImportJobStatus.wrap(impl.status())
    override val uploadId: UploadId =
      zio.aws.wisdom.model.primitives.UploadId(impl.uploadId())
    override val url: Url = zio.aws.wisdom.model.primitives.Url(impl.url())
    override val urlExpiry: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.urlExpiry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ImportJobData
  ): zio.aws.wisdom.model.ImportJobData.ReadOnly = new Wrapper(impl)
}
