package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait ImportJobStatus {
  def unwrap: software.amazon.awssdk.services.wisdom.model.ImportJobStatus
}
object ImportJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.ImportJobStatus
  ): zio.aws.wisdom.model.ImportJobStatus = value match {
    case software.amazon.awssdk.services.wisdom.model.ImportJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.ImportJobStatus.START_IN_PROGRESS =>
      val r = START_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.ImportJobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.ImportJobStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.wisdom.model.ImportJobStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.ImportJobStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.ImportJobStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.ImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobStatus =
      software.amazon.awssdk.services.wisdom.model.ImportJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object START_IN_PROGRESS extends zio.aws.wisdom.model.ImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobStatus =
      software.amazon.awssdk.services.wisdom.model.ImportJobStatus.START_IN_PROGRESS
  }
  case object FAILED extends zio.aws.wisdom.model.ImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobStatus =
      software.amazon.awssdk.services.wisdom.model.ImportJobStatus.FAILED
  }
  case object COMPLETE extends zio.aws.wisdom.model.ImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobStatus =
      software.amazon.awssdk.services.wisdom.model.ImportJobStatus.COMPLETE
  }
  case object DELETE_IN_PROGRESS extends zio.aws.wisdom.model.ImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobStatus =
      software.amazon.awssdk.services.wisdom.model.ImportJobStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED extends zio.aws.wisdom.model.ImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobStatus =
      software.amazon.awssdk.services.wisdom.model.ImportJobStatus.DELETE_FAILED
  }
  case object DELETED extends zio.aws.wisdom.model.ImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobStatus =
      software.amazon.awssdk.services.wisdom.model.ImportJobStatus.DELETED
  }
}
