package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  UploadId,
  SyntheticTimestamp_epoch_seconds,
  Arn,
  Uuid,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ImportJobSummary(
    createdTime: SyntheticTimestamp_epoch_seconds,
    externalSourceConfiguration: Optional[
      zio.aws.wisdom.model.ExternalSourceConfiguration
    ] = Optional.Absent,
    importJobId: Uuid,
    importJobType: zio.aws.wisdom.model.ImportJobType,
    knowledgeBaseArn: Arn,
    knowledgeBaseId: Uuid,
    lastModifiedTime: SyntheticTimestamp_epoch_seconds,
    metadata: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    status: zio.aws.wisdom.model.ImportJobStatus,
    uploadId: UploadId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ImportJobSummary = {
    import ImportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ImportJobSummary
      .builder()
      .createdTime(
        SyntheticTimestamp_epoch_seconds.unwrap(createdTime): Instant
      )
      .optionallyWith(
        externalSourceConfiguration.map(value => value.buildAwsValue())
      )(_.externalSourceConfiguration)
      .importJobId(Uuid.unwrap(importJobId): java.lang.String)
      .importJobType(importJobType.unwrap)
      .knowledgeBaseArn(Arn.unwrap(knowledgeBaseArn): java.lang.String)
      .knowledgeBaseId(Uuid.unwrap(knowledgeBaseId): java.lang.String)
      .lastModifiedTime(
        SyntheticTimestamp_epoch_seconds.unwrap(lastModifiedTime): Instant
      )
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .status(status.unwrap)
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ImportJobSummary.ReadOnly =
    zio.aws.wisdom.model.ImportJobSummary.wrap(buildAwsValue())
}
object ImportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ImportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ImportJobSummary =
      zio.aws.wisdom.model.ImportJobSummary(
        createdTime,
        externalSourceConfiguration.map(value => value.asEditable),
        importJobId,
        importJobType,
        knowledgeBaseArn,
        knowledgeBaseId,
        lastModifiedTime,
        metadata.map(value => value),
        status,
        uploadId
      )
    def createdTime: SyntheticTimestamp_epoch_seconds
    def externalSourceConfiguration
        : Optional[zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly]
    def importJobId: Uuid
    def importJobType: zio.aws.wisdom.model.ImportJobType
    def knowledgeBaseArn: Arn
    def knowledgeBaseId: Uuid
    def lastModifiedTime: SyntheticTimestamp_epoch_seconds
    def metadata: Optional[Map[NonEmptyString, NonEmptyString]]
    def status: zio.aws.wisdom.model.ImportJobStatus
    def uploadId: UploadId
    def getCreatedTime: ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(createdTime)
    def getExternalSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalSourceConfiguration",
      externalSourceConfiguration
    )
    def getImportJobId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(importJobId)
    def getImportJobType
        : ZIO[Any, Nothing, zio.aws.wisdom.model.ImportJobType] =
      ZIO.succeed(importJobType)
    def getKnowledgeBaseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(knowledgeBaseId)
    def getLastModifiedTime
        : ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(lastModifiedTime)
    def getMetadata: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.ImportJobStatus] =
      ZIO.succeed(status)
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ImportJobSummary
  ) extends zio.aws.wisdom.model.ImportJobSummary.ReadOnly {
    override val createdTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.createdTime())
    override val externalSourceConfiguration
        : Optional[zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalSourceConfiguration())
        .map(value =>
          zio.aws.wisdom.model.ExternalSourceConfiguration.wrap(value)
        )
    override val importJobId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.importJobId())
    override val importJobType: zio.aws.wisdom.model.ImportJobType =
      zio.aws.wisdom.model.ImportJobType.wrap(impl.importJobType())
    override val knowledgeBaseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.knowledgeBaseArn())
    override val knowledgeBaseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.knowledgeBaseId())
    override val lastModifiedTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.lastModifiedTime())
    override val metadata: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.wisdom.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.wisdom.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val status: zio.aws.wisdom.model.ImportJobStatus =
      zio.aws.wisdom.model.ImportJobStatus.wrap(impl.status())
    override val uploadId: UploadId =
      zio.aws.wisdom.model.primitives.UploadId(impl.uploadId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ImportJobSummary
  ): zio.aws.wisdom.model.ImportJobSummary.ReadOnly = new Wrapper(impl)
}
