package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait ImportJobType {
  def unwrap: software.amazon.awssdk.services.wisdom.model.ImportJobType
}
object ImportJobType {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.ImportJobType
  ): zio.aws.wisdom.model.ImportJobType = value match {
    case software.amazon.awssdk.services.wisdom.model.ImportJobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.ImportJobType.QUICK_RESPONSES =>
      val r = QUICK_RESPONSES
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.ImportJobType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobType =
      software.amazon.awssdk.services.wisdom.model.ImportJobType.UNKNOWN_TO_SDK_VERSION
  }
  case object QUICK_RESPONSES extends zio.aws.wisdom.model.ImportJobType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ImportJobType =
      software.amazon.awssdk.services.wisdom.model.ImportJobType.QUICK_RESPONSES
  }
}
