package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{Uuid, Arn}
import scala.jdk.CollectionConverters.*
final case class KnowledgeBaseAssociationData(
    knowledgeBaseArn: Optional[Arn] = Optional.Absent,
    knowledgeBaseId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseAssociationData = {
    import KnowledgeBaseAssociationData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.KnowledgeBaseAssociationData
      .builder()
      .optionallyWith(
        knowledgeBaseArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.knowledgeBaseArn)
      .optionallyWith(
        knowledgeBaseId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.knowledgeBaseId)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.KnowledgeBaseAssociationData.ReadOnly =
    zio.aws.wisdom.model.KnowledgeBaseAssociationData.wrap(buildAwsValue())
}
object KnowledgeBaseAssociationData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.KnowledgeBaseAssociationData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.KnowledgeBaseAssociationData =
      zio.aws.wisdom.model.KnowledgeBaseAssociationData(
        knowledgeBaseArn.map(value => value),
        knowledgeBaseId.map(value => value)
      )
    def knowledgeBaseArn: Optional[Arn]
    def knowledgeBaseId: Optional[Uuid]
    def getKnowledgeBaseArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("knowledgeBaseArn", knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("knowledgeBaseId", knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.KnowledgeBaseAssociationData
  ) extends zio.aws.wisdom.model.KnowledgeBaseAssociationData.ReadOnly {
    override val knowledgeBaseArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.knowledgeBaseArn())
      .map(value => zio.aws.wisdom.model.primitives.Arn(value))
    override val knowledgeBaseId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.knowledgeBaseId())
      .map(value => zio.aws.wisdom.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.KnowledgeBaseAssociationData
  ): zio.aws.wisdom.model.KnowledgeBaseAssociationData.ReadOnly = new Wrapper(
    impl
  )
}
