package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait KnowledgeBaseType {
  def unwrap: software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType
}
object KnowledgeBaseType {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType
  ): zio.aws.wisdom.model.KnowledgeBaseType = value match {
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType.EXTERNAL =>
      val r = EXTERNAL
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType.QUICK_RESPONSES =>
      val r = QUICK_RESPONSES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wisdom.model.KnowledgeBaseType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType.UNKNOWN_TO_SDK_VERSION
  }
  case object EXTERNAL extends zio.aws.wisdom.model.KnowledgeBaseType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType.EXTERNAL
  }
  case object CUSTOM extends zio.aws.wisdom.model.KnowledgeBaseType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType.CUSTOM
  }
  case object QUICK_RESPONSES extends zio.aws.wisdom.model.KnowledgeBaseType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseType.QUICK_RESPONSES
  }
}
