package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{NextToken, MaxResults, UuidOrArn}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAssistantAssociationsRequest(
    assistantId: UuidOrArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsRequest = {
    import ListAssistantAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.ListAssistantAssociationsRequest.ReadOnly =
    zio.aws.wisdom.model.ListAssistantAssociationsRequest.wrap(buildAwsValue())
}
object ListAssistantAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListAssistantAssociationsRequest =
      zio.aws.wisdom.model.ListAssistantAssociationsRequest(
        assistantId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def assistantId: UuidOrArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsRequest
  ) extends zio.aws.wisdom.model.ListAssistantAssociationsRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsRequest
  ): zio.aws.wisdom.model.ListAssistantAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
