package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAssistantsResponse(
    assistantSummaries: Iterable[zio.aws.wisdom.model.AssistantSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListAssistantsResponse = {
    import ListAssistantsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListAssistantsResponse
      .builder()
      .assistantSummaries(assistantSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ListAssistantsResponse.ReadOnly =
    zio.aws.wisdom.model.ListAssistantsResponse.wrap(buildAwsValue())
}
object ListAssistantsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListAssistantsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListAssistantsResponse =
      zio.aws.wisdom.model.ListAssistantsResponse(
        assistantSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assistantSummaries: List[zio.aws.wisdom.model.AssistantSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAssistantSummaries: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.AssistantSummary.ReadOnly
    ]] = ZIO.succeed(assistantSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListAssistantsResponse
  ) extends zio.aws.wisdom.model.ListAssistantsResponse.ReadOnly {
    override val assistantSummaries
        : List[zio.aws.wisdom.model.AssistantSummary.ReadOnly] = impl
      .assistantSummaries()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.AssistantSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListAssistantsResponse
  ): zio.aws.wisdom.model.ListAssistantsResponse.ReadOnly = new Wrapper(impl)
}
