package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{NonEmptyString, MaxResults, UuidOrArn}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListImportJobsRequest(
    knowledgeBaseId: UuidOrArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListImportJobsRequest = {
    import ListImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListImportJobsRequest
      .builder()
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ListImportJobsRequest.ReadOnly =
    zio.aws.wisdom.model.ListImportJobsRequest.wrap(buildAwsValue())
}
object ListImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListImportJobsRequest =
      zio.aws.wisdom.model.ListImportJobsRequest(
        knowledgeBaseId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def knowledgeBaseId: UuidOrArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NonEmptyString]
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListImportJobsRequest
  ) extends zio.aws.wisdom.model.ListImportJobsRequest.ReadOnly {
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListImportJobsRequest
  ): zio.aws.wisdom.model.ListImportJobsRequest.ReadOnly = new Wrapper(impl)
}
