package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ListImportJobsResponse(
    importJobSummaries: Iterable[zio.aws.wisdom.model.ImportJobSummary],
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListImportJobsResponse = {
    import ListImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListImportJobsResponse
      .builder()
      .importJobSummaries(importJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ListImportJobsResponse.ReadOnly =
    zio.aws.wisdom.model.ListImportJobsResponse.wrap(buildAwsValue())
}
object ListImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListImportJobsResponse =
      zio.aws.wisdom.model.ListImportJobsResponse(
        importJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def importJobSummaries: List[zio.aws.wisdom.model.ImportJobSummary.ReadOnly]
    def nextToken: Optional[NonEmptyString]
    def getImportJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.ImportJobSummary.ReadOnly
    ]] = ZIO.succeed(importJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListImportJobsResponse
  ) extends zio.aws.wisdom.model.ListImportJobsResponse.ReadOnly {
    override val importJobSummaries
        : List[zio.aws.wisdom.model.ImportJobSummary.ReadOnly] = impl
      .importJobSummaries()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.ImportJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListImportJobsResponse
  ): zio.aws.wisdom.model.ListImportJobsResponse.ReadOnly = new Wrapper(impl)
}
