package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ListQuickResponsesResponse(
    nextToken: Optional[NonEmptyString] = Optional.Absent,
    quickResponseSummaries: Iterable[zio.aws.wisdom.model.QuickResponseSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListQuickResponsesResponse = {
    import ListQuickResponsesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListQuickResponsesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .quickResponseSummaries(quickResponseSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ListQuickResponsesResponse.ReadOnly =
    zio.aws.wisdom.model.ListQuickResponsesResponse.wrap(buildAwsValue())
}
object ListQuickResponsesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListQuickResponsesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListQuickResponsesResponse =
      zio.aws.wisdom.model.ListQuickResponsesResponse(
        nextToken.map(value => value),
        quickResponseSummaries.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NonEmptyString]
    def quickResponseSummaries
        : List[zio.aws.wisdom.model.QuickResponseSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQuickResponseSummaries: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.QuickResponseSummary.ReadOnly
    ]] = ZIO.succeed(quickResponseSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListQuickResponsesResponse
  ) extends zio.aws.wisdom.model.ListQuickResponsesResponse.ReadOnly {
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
    override val quickResponseSummaries
        : List[zio.aws.wisdom.model.QuickResponseSummary.ReadOnly] = impl
      .quickResponseSummaries()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.QuickResponseSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListQuickResponsesResponse
  ): zio.aws.wisdom.model.ListQuickResponsesResponse.ReadOnly = new Wrapper(
    impl
  )
}
