package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait Order {
  def unwrap: software.amazon.awssdk.services.wisdom.model.Order
}
object Order {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.Order
  ): zio.aws.wisdom.model.Order = value match {
    case software.amazon.awssdk.services.wisdom.model.Order.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.Order.ASC =>
      val r = ASC
      r
    case software.amazon.awssdk.services.wisdom.model.Order.DESC =>
      val r = DESC
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.Order {
    override def unwrap: software.amazon.awssdk.services.wisdom.model.Order =
      software.amazon.awssdk.services.wisdom.model.Order.UNKNOWN_TO_SDK_VERSION
  }
  case object ASC extends zio.aws.wisdom.model.Order {
    override def unwrap: software.amazon.awssdk.services.wisdom.model.Order =
      software.amazon.awssdk.services.wisdom.model.Order.ASC
  }
  case object DESC extends zio.aws.wisdom.model.Order {
    override def unwrap: software.amazon.awssdk.services.wisdom.model.Order =
      software.amazon.awssdk.services.wisdom.model.Order.DESC
  }
}
