package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait Priority {
  def unwrap: software.amazon.awssdk.services.wisdom.model.Priority
}
object Priority {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.Priority
  ): zio.aws.wisdom.model.Priority = value match {
    case software.amazon.awssdk.services.wisdom.model.Priority.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.Priority.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.wisdom.model.Priority.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.wisdom.model.Priority.LOW =>
      val r = LOW
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.Priority {
    override def unwrap: software.amazon.awssdk.services.wisdom.model.Priority =
      software.amazon.awssdk.services.wisdom.model.Priority.UNKNOWN_TO_SDK_VERSION
  }
  case object HIGH extends zio.aws.wisdom.model.Priority {
    override def unwrap: software.amazon.awssdk.services.wisdom.model.Priority =
      software.amazon.awssdk.services.wisdom.model.Priority.HIGH
  }
  case object MEDIUM extends zio.aws.wisdom.model.Priority {
    override def unwrap: software.amazon.awssdk.services.wisdom.model.Priority =
      software.amazon.awssdk.services.wisdom.model.Priority.MEDIUM
  }
  case object LOW extends zio.aws.wisdom.model.Priority {
    override def unwrap: software.amazon.awssdk.services.wisdom.model.Priority =
      software.amazon.awssdk.services.wisdom.model.Priority.LOW
  }
}
