package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QuickResponseContents(
    markdown: Optional[zio.aws.wisdom.model.QuickResponseContentProvider] =
      Optional.Absent,
    plainText: Optional[zio.aws.wisdom.model.QuickResponseContentProvider] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseContents = {
    import QuickResponseContents.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseContents
      .builder()
      .optionallyWith(markdown.map(value => value.buildAwsValue()))(_.markdown)
      .optionallyWith(plainText.map(value => value.buildAwsValue()))(
        _.plainText
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseContents.ReadOnly =
    zio.aws.wisdom.model.QuickResponseContents.wrap(buildAwsValue())
}
object QuickResponseContents {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseContents
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseContents =
      zio.aws.wisdom.model.QuickResponseContents(
        markdown.map(value => value.asEditable),
        plainText.map(value => value.asEditable)
      )
    def markdown
        : Optional[zio.aws.wisdom.model.QuickResponseContentProvider.ReadOnly]
    def plainText
        : Optional[zio.aws.wisdom.model.QuickResponseContentProvider.ReadOnly]
    def getMarkdown: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.QuickResponseContentProvider.ReadOnly
    ] = AwsError.unwrapOptionField("markdown", markdown)
    def getPlainText: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.QuickResponseContentProvider.ReadOnly
    ] = AwsError.unwrapOptionField("plainText", plainText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseContents
  ) extends zio.aws.wisdom.model.QuickResponseContents.ReadOnly {
    override val markdown
        : Optional[zio.aws.wisdom.model.QuickResponseContentProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.markdown())
        .map(value =>
          zio.aws.wisdom.model.QuickResponseContentProvider.wrap(value)
        )
    override val plainText
        : Optional[zio.aws.wisdom.model.QuickResponseContentProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.plainText())
        .map(value =>
          zio.aws.wisdom.model.QuickResponseContentProvider.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseContents
  ): zio.aws.wisdom.model.QuickResponseContents.ReadOnly = new Wrapper(impl)
}
