package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  SyntheticTimestamp_epoch_seconds,
  QuickResponseName,
  LanguageCode,
  TagValue,
  Arn,
  GenericArn,
  Uuid,
  QuickResponseType,
  ShortCutKey,
  Channel,
  QuickResponseDescription,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class QuickResponseData(
    channels: Optional[Iterable[Channel]] = Optional.Absent,
    contentType: QuickResponseType,
    contents: Optional[zio.aws.wisdom.model.QuickResponseContents] =
      Optional.Absent,
    createdTime: SyntheticTimestamp_epoch_seconds,
    description: Optional[QuickResponseDescription] = Optional.Absent,
    groupingConfiguration: Optional[
      zio.aws.wisdom.model.GroupingConfiguration
    ] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent,
    knowledgeBaseArn: Arn,
    knowledgeBaseId: Uuid,
    language: Optional[LanguageCode] = Optional.Absent,
    lastModifiedBy: Optional[GenericArn] = Optional.Absent,
    lastModifiedTime: SyntheticTimestamp_epoch_seconds,
    name: QuickResponseName,
    quickResponseArn: Arn,
    quickResponseId: Uuid,
    shortcutKey: Optional[ShortCutKey] = Optional.Absent,
    status: zio.aws.wisdom.model.QuickResponseStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseData = {
    import QuickResponseData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseData
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            Channel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.channels)
      .contentType(QuickResponseType.unwrap(contentType): java.lang.String)
      .optionallyWith(contents.map(value => value.buildAwsValue()))(_.contents)
      .createdTime(
        SyntheticTimestamp_epoch_seconds.unwrap(createdTime): Instant
      )
      .optionallyWith(
        description.map(value =>
          QuickResponseDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        groupingConfiguration.map(value => value.buildAwsValue())
      )(_.groupingConfiguration)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .knowledgeBaseArn(Arn.unwrap(knowledgeBaseArn): java.lang.String)
      .knowledgeBaseId(Uuid.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        language.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        lastModifiedBy.map(value => GenericArn.unwrap(value): java.lang.String)
      )(_.lastModifiedBy)
      .lastModifiedTime(
        SyntheticTimestamp_epoch_seconds.unwrap(lastModifiedTime): Instant
      )
      .name(QuickResponseName.unwrap(name): java.lang.String)
      .quickResponseArn(Arn.unwrap(quickResponseArn): java.lang.String)
      .quickResponseId(Uuid.unwrap(quickResponseId): java.lang.String)
      .optionallyWith(
        shortcutKey.map(value => ShortCutKey.unwrap(value): java.lang.String)
      )(_.shortcutKey)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseData.ReadOnly =
    zio.aws.wisdom.model.QuickResponseData.wrap(buildAwsValue())
}
object QuickResponseData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseData =
      zio.aws.wisdom.model.QuickResponseData(
        channels.map(value => value),
        contentType,
        contents.map(value => value.asEditable),
        createdTime,
        description.map(value => value),
        groupingConfiguration.map(value => value.asEditable),
        isActive.map(value => value),
        knowledgeBaseArn,
        knowledgeBaseId,
        language.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedTime,
        name,
        quickResponseArn,
        quickResponseId,
        shortcutKey.map(value => value),
        status,
        tags.map(value => value)
      )
    def channels: Optional[List[Channel]]
    def contentType: QuickResponseType
    def contents: Optional[zio.aws.wisdom.model.QuickResponseContents.ReadOnly]
    def createdTime: SyntheticTimestamp_epoch_seconds
    def description: Optional[QuickResponseDescription]
    def groupingConfiguration
        : Optional[zio.aws.wisdom.model.GroupingConfiguration.ReadOnly]
    def isActive: Optional[Boolean]
    def knowledgeBaseArn: Arn
    def knowledgeBaseId: Uuid
    def language: Optional[LanguageCode]
    def lastModifiedBy: Optional[GenericArn]
    def lastModifiedTime: SyntheticTimestamp_epoch_seconds
    def name: QuickResponseName
    def quickResponseArn: Arn
    def quickResponseId: Uuid
    def shortcutKey: Optional[ShortCutKey]
    def status: zio.aws.wisdom.model.QuickResponseStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def getChannels: ZIO[Any, AwsError, List[Channel]] =
      AwsError.unwrapOptionField("channels", channels)
    def getContentType: ZIO[Any, Nothing, QuickResponseType] =
      ZIO.succeed(contentType)
    def getContents: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.QuickResponseContents.ReadOnly
    ] = AwsError.unwrapOptionField("contents", contents)
    def getCreatedTime: ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, AwsError, QuickResponseDescription] =
      AwsError.unwrapOptionField("description", description)
    def getGroupingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.GroupingConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("groupingConfiguration", groupingConfiguration)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
    def getKnowledgeBaseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(knowledgeBaseId)
    def getLanguage: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("language", language)
    def getLastModifiedBy: ZIO[Any, AwsError, GenericArn] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedTime
        : ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(lastModifiedTime)
    def getName: ZIO[Any, Nothing, QuickResponseName] = ZIO.succeed(name)
    def getQuickResponseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(quickResponseArn)
    def getQuickResponseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(quickResponseId)
    def getShortcutKey: ZIO[Any, AwsError, ShortCutKey] =
      AwsError.unwrapOptionField("shortcutKey", shortcutKey)
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.QuickResponseStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseData
  ) extends zio.aws.wisdom.model.QuickResponseData.ReadOnly {
    override val channels: Optional[List[Channel]] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.primitives.Channel(item)
        }.toList
      )
    override val contentType: QuickResponseType =
      zio.aws.wisdom.model.primitives.QuickResponseType(impl.contentType())
    override val contents
        : Optional[zio.aws.wisdom.model.QuickResponseContents.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contents())
        .map(value => zio.aws.wisdom.model.QuickResponseContents.wrap(value))
    override val createdTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.createdTime())
    override val description: Optional[QuickResponseDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.wisdom.model.primitives.QuickResponseDescription(value)
        )
    override val groupingConfiguration
        : Optional[zio.aws.wisdom.model.GroupingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupingConfiguration())
        .map(value => zio.aws.wisdom.model.GroupingConfiguration.wrap(value))
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
    override val knowledgeBaseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.knowledgeBaseArn())
    override val knowledgeBaseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.knowledgeBaseId())
    override val language: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.wisdom.model.primitives.LanguageCode(value))
    override val lastModifiedBy: Optional[GenericArn] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => zio.aws.wisdom.model.primitives.GenericArn(value))
    override val lastModifiedTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.lastModifiedTime())
    override val name: QuickResponseName =
      zio.aws.wisdom.model.primitives.QuickResponseName(impl.name())
    override val quickResponseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.quickResponseArn())
    override val quickResponseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.quickResponseId())
    override val shortcutKey: Optional[ShortCutKey] = zio.aws.core.internal
      .optionalFromNullable(impl.shortcutKey())
      .map(value => zio.aws.wisdom.model.primitives.ShortCutKey(value))
    override val status: zio.aws.wisdom.model.QuickResponseStatus =
      zio.aws.wisdom.model.QuickResponseStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseData
  ): zio.aws.wisdom.model.QuickResponseData.ReadOnly = new Wrapper(impl)
}
