package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.QuickResponseContent
import scala.jdk.CollectionConverters.*
final case class QuickResponseDataProvider(
    content: Optional[QuickResponseContent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseDataProvider = {
    import QuickResponseDataProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseDataProvider
      .builder()
      .optionallyWith(
        content.map(value =>
          QuickResponseContent.unwrap(value): java.lang.String
        )
      )(_.content)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly =
    zio.aws.wisdom.model.QuickResponseDataProvider.wrap(buildAwsValue())
}
object QuickResponseDataProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseDataProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseDataProvider =
      zio.aws.wisdom.model
        .QuickResponseDataProvider(content.map(value => value))
    def content: Optional[QuickResponseContent]
    def getContent: ZIO[Any, AwsError, QuickResponseContent] =
      AwsError.unwrapOptionField("content", content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseDataProvider
  ) extends zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly {
    override val content: Optional[QuickResponseContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.wisdom.model.primitives.QuickResponseContent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseDataProvider
  ): zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly = new Wrapper(impl)
}
