package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  QuickResponseFilterValue,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class QuickResponseFilterField(
    includeNoExistence: Optional[Boolean] = Optional.Absent,
    name: NonEmptyString,
    operator: zio.aws.wisdom.model.QuickResponseFilterOperator,
    values: Optional[Iterable[QuickResponseFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField = {
    import QuickResponseFilterField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField
      .builder()
      .optionallyWith(
        includeNoExistence.map(value => value: java.lang.Boolean)
      )(_.includeNoExistence)
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .operator(operator.unwrap)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            QuickResponseFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseFilterField.ReadOnly =
    zio.aws.wisdom.model.QuickResponseFilterField.wrap(buildAwsValue())
}
object QuickResponseFilterField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseFilterField =
      zio.aws.wisdom.model.QuickResponseFilterField(
        includeNoExistence.map(value => value),
        name,
        operator,
        values.map(value => value)
      )
    def includeNoExistence: Optional[Boolean]
    def name: NonEmptyString
    def operator: zio.aws.wisdom.model.QuickResponseFilterOperator
    def values: Optional[List[QuickResponseFilterValue]]
    def getIncludeNoExistence: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeNoExistence", includeNoExistence)
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.wisdom.model.QuickResponseFilterOperator] =
      ZIO.succeed(operator)
    def getValues: ZIO[Any, AwsError, List[QuickResponseFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField
  ) extends zio.aws.wisdom.model.QuickResponseFilterField.ReadOnly {
    override val includeNoExistence: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeNoExistence())
      .map(value => value: Boolean)
    override val name: NonEmptyString =
      zio.aws.wisdom.model.primitives.NonEmptyString(impl.name())
    override val operator: zio.aws.wisdom.model.QuickResponseFilterOperator =
      zio.aws.wisdom.model.QuickResponseFilterOperator.wrap(impl.operator())
    override val values: Optional[List[QuickResponseFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wisdom.model.primitives.QuickResponseFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField
  ): zio.aws.wisdom.model.QuickResponseFilterField.ReadOnly = new Wrapper(impl)
}
