package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait QuickResponseFilterOperator {
  def unwrap
      : software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator
}
object QuickResponseFilterOperator {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator
  ): zio.aws.wisdom.model.QuickResponseFilterOperator = value match {
    case software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator.EQUALS =>
      val r = EQUALS
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator.PREFIX =>
      val r = PREFIX
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wisdom.model.QuickResponseFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator =
      software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.wisdom.model.QuickResponseFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator =
      software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator.EQUALS
  }
  case object PREFIX extends zio.aws.wisdom.model.QuickResponseFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator =
      software.amazon.awssdk.services.wisdom.model.QuickResponseFilterOperator.PREFIX
  }
}
