package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class QuickResponseOrderField(
    name: NonEmptyString,
    order: Optional[zio.aws.wisdom.model.Order] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseOrderField = {
    import QuickResponseOrderField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseOrderField
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseOrderField.ReadOnly =
    zio.aws.wisdom.model.QuickResponseOrderField.wrap(buildAwsValue())
}
object QuickResponseOrderField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseOrderField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseOrderField =
      zio.aws.wisdom.model
        .QuickResponseOrderField(name, order.map(value => value))
    def name: NonEmptyString
    def order: Optional[zio.aws.wisdom.model.Order]
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getOrder: ZIO[Any, AwsError, zio.aws.wisdom.model.Order] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseOrderField
  ) extends zio.aws.wisdom.model.QuickResponseOrderField.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.wisdom.model.primitives.NonEmptyString(impl.name())
    override val order: Optional[zio.aws.wisdom.model.Order] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.wisdom.model.Order.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseOrderField
  ): zio.aws.wisdom.model.QuickResponseOrderField.ReadOnly = new Wrapper(impl)
}
