package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{QuickResponseQueryValue, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class QuickResponseQueryField(
    allowFuzziness: Optional[Boolean] = Optional.Absent,
    name: NonEmptyString,
    operator: zio.aws.wisdom.model.QuickResponseQueryOperator,
    priority: Optional[zio.aws.wisdom.model.Priority] = Optional.Absent,
    values: Iterable[QuickResponseQueryValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField = {
    import QuickResponseQueryField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField
      .builder()
      .optionallyWith(allowFuzziness.map(value => value: java.lang.Boolean))(
        _.allowFuzziness
      )
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .operator(operator.unwrap)
      .optionallyWith(priority.map(value => value.unwrap))(_.priority)
      .values(values.map { item =>
        QuickResponseQueryValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseQueryField.ReadOnly =
    zio.aws.wisdom.model.QuickResponseQueryField.wrap(buildAwsValue())
}
object QuickResponseQueryField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseQueryField =
      zio.aws.wisdom.model.QuickResponseQueryField(
        allowFuzziness.map(value => value),
        name,
        operator,
        priority.map(value => value),
        values
      )
    def allowFuzziness: Optional[Boolean]
    def name: NonEmptyString
    def operator: zio.aws.wisdom.model.QuickResponseQueryOperator
    def priority: Optional[zio.aws.wisdom.model.Priority]
    def values: List[QuickResponseQueryValue]
    def getAllowFuzziness: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowFuzziness", allowFuzziness)
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.wisdom.model.QuickResponseQueryOperator] =
      ZIO.succeed(operator)
    def getPriority: ZIO[Any, AwsError, zio.aws.wisdom.model.Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getValues: ZIO[Any, Nothing, List[QuickResponseQueryValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField
  ) extends zio.aws.wisdom.model.QuickResponseQueryField.ReadOnly {
    override val allowFuzziness: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowFuzziness())
      .map(value => value: Boolean)
    override val name: NonEmptyString =
      zio.aws.wisdom.model.primitives.NonEmptyString(impl.name())
    override val operator: zio.aws.wisdom.model.QuickResponseQueryOperator =
      zio.aws.wisdom.model.QuickResponseQueryOperator.wrap(impl.operator())
    override val priority: Optional[zio.aws.wisdom.model.Priority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value => zio.aws.wisdom.model.Priority.wrap(value))
    override val values: List[QuickResponseQueryValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.primitives.QuickResponseQueryValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField
  ): zio.aws.wisdom.model.QuickResponseQueryField.ReadOnly = new Wrapper(impl)
}
