package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait QuickResponseQueryOperator {
  def unwrap
      : software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator
}
object QuickResponseQueryOperator {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator
  ): zio.aws.wisdom.model.QuickResponseQueryOperator = value match {
    case software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator.CONTAINS =>
      val r = CONTAINS
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator.CONTAINS_AND_PREFIX =>
      val r = CONTAINS_AND_PREFIX
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wisdom.model.QuickResponseQueryOperator {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator =
      software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTAINS extends zio.aws.wisdom.model.QuickResponseQueryOperator {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator =
      software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator.CONTAINS
  }
  case object CONTAINS_AND_PREFIX
      extends zio.aws.wisdom.model.QuickResponseQueryOperator {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator =
      software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator.CONTAINS_AND_PREFIX
  }
}
