package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QuickResponseSearchExpression(
    filters: Optional[Iterable[zio.aws.wisdom.model.QuickResponseFilterField]] =
      Optional.Absent,
    orderOnField: Optional[zio.aws.wisdom.model.QuickResponseOrderField] =
      Optional.Absent,
    queries: Optional[Iterable[zio.aws.wisdom.model.QuickResponseQueryField]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseSearchExpression = {
    import QuickResponseSearchExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseSearchExpression
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(orderOnField.map(value => value.buildAwsValue()))(
        _.orderOnField
      )
      .optionallyWith(
        queries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queries)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseSearchExpression.ReadOnly =
    zio.aws.wisdom.model.QuickResponseSearchExpression.wrap(buildAwsValue())
}
object QuickResponseSearchExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseSearchExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseSearchExpression =
      zio.aws.wisdom.model.QuickResponseSearchExpression(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orderOnField.map(value => value.asEditable),
        queries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def filters
        : Optional[List[zio.aws.wisdom.model.QuickResponseFilterField.ReadOnly]]
    def orderOnField
        : Optional[zio.aws.wisdom.model.QuickResponseOrderField.ReadOnly]
    def queries
        : Optional[List[zio.aws.wisdom.model.QuickResponseQueryField.ReadOnly]]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.wisdom.model.QuickResponseFilterField.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getOrderOnField: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.QuickResponseOrderField.ReadOnly
    ] = AwsError.unwrapOptionField("orderOnField", orderOnField)
    def getQueries: ZIO[Any, AwsError, List[
      zio.aws.wisdom.model.QuickResponseQueryField.ReadOnly
    ]] = AwsError.unwrapOptionField("queries", queries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseSearchExpression
  ) extends zio.aws.wisdom.model.QuickResponseSearchExpression.ReadOnly {
    override val filters: Optional[
      List[zio.aws.wisdom.model.QuickResponseFilterField.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.QuickResponseFilterField.wrap(item)
        }.toList
      )
    override val orderOnField
        : Optional[zio.aws.wisdom.model.QuickResponseOrderField.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderOnField())
        .map(value => zio.aws.wisdom.model.QuickResponseOrderField.wrap(value))
    override val queries: Optional[
      List[zio.aws.wisdom.model.QuickResponseQueryField.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.queries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.QuickResponseQueryField.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseSearchExpression
  ): zio.aws.wisdom.model.QuickResponseSearchExpression.ReadOnly = new Wrapper(
    impl
  )
}
