package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  SyntheticTimestamp_epoch_seconds,
  QuickResponseName,
  LanguageCode,
  TagValue,
  Arn,
  GenericArn,
  Uuid,
  QuickResponseType,
  ContactAttributeKey,
  ShortCutKey,
  Channel,
  QuickResponseDescription,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class QuickResponseSearchResultData(
    attributesInterpolated: Optional[Iterable[ContactAttributeKey]] =
      Optional.Absent,
    attributesNotInterpolated: Optional[Iterable[ContactAttributeKey]] =
      Optional.Absent,
    channels: Optional[Iterable[Channel]] = Optional.Absent,
    contentType: QuickResponseType,
    contents: zio.aws.wisdom.model.QuickResponseContents,
    createdTime: SyntheticTimestamp_epoch_seconds,
    description: Optional[QuickResponseDescription] = Optional.Absent,
    groupingConfiguration: Optional[
      zio.aws.wisdom.model.GroupingConfiguration
    ] = Optional.Absent,
    isActive: Boolean,
    knowledgeBaseArn: Arn,
    knowledgeBaseId: Uuid,
    language: Optional[LanguageCode] = Optional.Absent,
    lastModifiedBy: Optional[GenericArn] = Optional.Absent,
    lastModifiedTime: SyntheticTimestamp_epoch_seconds,
    name: QuickResponseName,
    quickResponseArn: Arn,
    quickResponseId: Uuid,
    shortcutKey: Optional[ShortCutKey] = Optional.Absent,
    status: zio.aws.wisdom.model.QuickResponseStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseSearchResultData = {
    import QuickResponseSearchResultData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseSearchResultData
      .builder()
      .optionallyWith(
        attributesInterpolated.map(value =>
          value.map { item =>
            ContactAttributeKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesInterpolated)
      .optionallyWith(
        attributesNotInterpolated.map(value =>
          value.map { item =>
            ContactAttributeKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesNotInterpolated)
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            Channel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.channels)
      .contentType(QuickResponseType.unwrap(contentType): java.lang.String)
      .contents(contents.buildAwsValue())
      .createdTime(
        SyntheticTimestamp_epoch_seconds.unwrap(createdTime): Instant
      )
      .optionallyWith(
        description.map(value =>
          QuickResponseDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        groupingConfiguration.map(value => value.buildAwsValue())
      )(_.groupingConfiguration)
      .isActive(isActive: java.lang.Boolean)
      .knowledgeBaseArn(Arn.unwrap(knowledgeBaseArn): java.lang.String)
      .knowledgeBaseId(Uuid.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        language.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        lastModifiedBy.map(value => GenericArn.unwrap(value): java.lang.String)
      )(_.lastModifiedBy)
      .lastModifiedTime(
        SyntheticTimestamp_epoch_seconds.unwrap(lastModifiedTime): Instant
      )
      .name(QuickResponseName.unwrap(name): java.lang.String)
      .quickResponseArn(Arn.unwrap(quickResponseArn): java.lang.String)
      .quickResponseId(Uuid.unwrap(quickResponseId): java.lang.String)
      .optionallyWith(
        shortcutKey.map(value => ShortCutKey.unwrap(value): java.lang.String)
      )(_.shortcutKey)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly =
    zio.aws.wisdom.model.QuickResponseSearchResultData.wrap(buildAwsValue())
}
object QuickResponseSearchResultData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseSearchResultData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseSearchResultData =
      zio.aws.wisdom.model.QuickResponseSearchResultData(
        attributesInterpolated.map(value => value),
        attributesNotInterpolated.map(value => value),
        channels.map(value => value),
        contentType,
        contents.asEditable,
        createdTime,
        description.map(value => value),
        groupingConfiguration.map(value => value.asEditable),
        isActive,
        knowledgeBaseArn,
        knowledgeBaseId,
        language.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedTime,
        name,
        quickResponseArn,
        quickResponseId,
        shortcutKey.map(value => value),
        status,
        tags.map(value => value)
      )
    def attributesInterpolated: Optional[List[ContactAttributeKey]]
    def attributesNotInterpolated: Optional[List[ContactAttributeKey]]
    def channels: Optional[List[Channel]]
    def contentType: QuickResponseType
    def contents: zio.aws.wisdom.model.QuickResponseContents.ReadOnly
    def createdTime: SyntheticTimestamp_epoch_seconds
    def description: Optional[QuickResponseDescription]
    def groupingConfiguration
        : Optional[zio.aws.wisdom.model.GroupingConfiguration.ReadOnly]
    def isActive: Boolean
    def knowledgeBaseArn: Arn
    def knowledgeBaseId: Uuid
    def language: Optional[LanguageCode]
    def lastModifiedBy: Optional[GenericArn]
    def lastModifiedTime: SyntheticTimestamp_epoch_seconds
    def name: QuickResponseName
    def quickResponseArn: Arn
    def quickResponseId: Uuid
    def shortcutKey: Optional[ShortCutKey]
    def status: zio.aws.wisdom.model.QuickResponseStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def getAttributesInterpolated
        : ZIO[Any, AwsError, List[ContactAttributeKey]] = AwsError
      .unwrapOptionField("attributesInterpolated", attributesInterpolated)
    def getAttributesNotInterpolated
        : ZIO[Any, AwsError, List[ContactAttributeKey]] = AwsError
      .unwrapOptionField("attributesNotInterpolated", attributesNotInterpolated)
    def getChannels: ZIO[Any, AwsError, List[Channel]] =
      AwsError.unwrapOptionField("channels", channels)
    def getContentType: ZIO[Any, Nothing, QuickResponseType] =
      ZIO.succeed(contentType)
    def getContents: ZIO[
      Any,
      Nothing,
      zio.aws.wisdom.model.QuickResponseContents.ReadOnly
    ] = ZIO.succeed(contents)
    def getCreatedTime: ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, AwsError, QuickResponseDescription] =
      AwsError.unwrapOptionField("description", description)
    def getGroupingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.GroupingConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("groupingConfiguration", groupingConfiguration)
    def getIsActive: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isActive)
    def getKnowledgeBaseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(knowledgeBaseId)
    def getLanguage: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("language", language)
    def getLastModifiedBy: ZIO[Any, AwsError, GenericArn] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedTime
        : ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(lastModifiedTime)
    def getName: ZIO[Any, Nothing, QuickResponseName] = ZIO.succeed(name)
    def getQuickResponseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(quickResponseArn)
    def getQuickResponseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(quickResponseId)
    def getShortcutKey: ZIO[Any, AwsError, ShortCutKey] =
      AwsError.unwrapOptionField("shortcutKey", shortcutKey)
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.QuickResponseStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseSearchResultData
  ) extends zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly {
    override val attributesInterpolated: Optional[List[ContactAttributeKey]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesInterpolated())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wisdom.model.primitives.ContactAttributeKey(item)
          }.toList
        )
    override val attributesNotInterpolated
        : Optional[List[ContactAttributeKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributesNotInterpolated())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.primitives.ContactAttributeKey(item)
        }.toList
      )
    override val channels: Optional[List[Channel]] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.primitives.Channel(item)
        }.toList
      )
    override val contentType: QuickResponseType =
      zio.aws.wisdom.model.primitives.QuickResponseType(impl.contentType())
    override val contents: zio.aws.wisdom.model.QuickResponseContents.ReadOnly =
      zio.aws.wisdom.model.QuickResponseContents.wrap(impl.contents())
    override val createdTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.createdTime())
    override val description: Optional[QuickResponseDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.wisdom.model.primitives.QuickResponseDescription(value)
        )
    override val groupingConfiguration
        : Optional[zio.aws.wisdom.model.GroupingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupingConfiguration())
        .map(value => zio.aws.wisdom.model.GroupingConfiguration.wrap(value))
    override val isActive: Boolean = impl.isActive(): Boolean
    override val knowledgeBaseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.knowledgeBaseArn())
    override val knowledgeBaseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.knowledgeBaseId())
    override val language: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.wisdom.model.primitives.LanguageCode(value))
    override val lastModifiedBy: Optional[GenericArn] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => zio.aws.wisdom.model.primitives.GenericArn(value))
    override val lastModifiedTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.lastModifiedTime())
    override val name: QuickResponseName =
      zio.aws.wisdom.model.primitives.QuickResponseName(impl.name())
    override val quickResponseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.quickResponseArn())
    override val quickResponseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.quickResponseId())
    override val shortcutKey: Optional[ShortCutKey] = zio.aws.core.internal
      .optionalFromNullable(impl.shortcutKey())
      .map(value => zio.aws.wisdom.model.primitives.ShortCutKey(value))
    override val status: zio.aws.wisdom.model.QuickResponseStatus =
      zio.aws.wisdom.model.QuickResponseStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseSearchResultData
  ): zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly = new Wrapper(
    impl
  )
}
