package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait QuickResponseStatus {
  def unwrap: software.amazon.awssdk.services.wisdom.model.QuickResponseStatus
}
object QuickResponseStatus {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.QuickResponseStatus
  ): zio.aws.wisdom.model.QuickResponseStatus = value match {
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_FAILED extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.CREATE_FAILED
  }
  case object CREATED extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.CREATED
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.DELETE_FAILED
  }
  case object DELETED extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.DELETED
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.UPDATE_IN_PROGRESS
  }
  case object UPDATE_FAILED extends zio.aws.wisdom.model.QuickResponseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.QuickResponseStatus =
      software.amazon.awssdk.services.wisdom.model.QuickResponseStatus.UPDATE_FAILED
  }
}
