package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  SyntheticTimestamp_epoch_seconds,
  QuickResponseName,
  TagValue,
  Arn,
  GenericArn,
  Uuid,
  QuickResponseType,
  Channel,
  QuickResponseDescription,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class QuickResponseSummary(
    channels: Optional[Iterable[Channel]] = Optional.Absent,
    contentType: QuickResponseType,
    createdTime: SyntheticTimestamp_epoch_seconds,
    description: Optional[QuickResponseDescription] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent,
    knowledgeBaseArn: Arn,
    knowledgeBaseId: Uuid,
    lastModifiedBy: Optional[GenericArn] = Optional.Absent,
    lastModifiedTime: SyntheticTimestamp_epoch_seconds,
    name: QuickResponseName,
    quickResponseArn: Arn,
    quickResponseId: Uuid,
    status: zio.aws.wisdom.model.QuickResponseStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QuickResponseSummary = {
    import QuickResponseSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QuickResponseSummary
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            Channel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.channels)
      .contentType(QuickResponseType.unwrap(contentType): java.lang.String)
      .createdTime(
        SyntheticTimestamp_epoch_seconds.unwrap(createdTime): Instant
      )
      .optionallyWith(
        description.map(value =>
          QuickResponseDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .knowledgeBaseArn(Arn.unwrap(knowledgeBaseArn): java.lang.String)
      .knowledgeBaseId(Uuid.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        lastModifiedBy.map(value => GenericArn.unwrap(value): java.lang.String)
      )(_.lastModifiedBy)
      .lastModifiedTime(
        SyntheticTimestamp_epoch_seconds.unwrap(lastModifiedTime): Instant
      )
      .name(QuickResponseName.unwrap(name): java.lang.String)
      .quickResponseArn(Arn.unwrap(quickResponseArn): java.lang.String)
      .quickResponseId(Uuid.unwrap(quickResponseId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QuickResponseSummary.ReadOnly =
    zio.aws.wisdom.model.QuickResponseSummary.wrap(buildAwsValue())
}
object QuickResponseSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QuickResponseSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QuickResponseSummary =
      zio.aws.wisdom.model.QuickResponseSummary(
        channels.map(value => value),
        contentType,
        createdTime,
        description.map(value => value),
        isActive.map(value => value),
        knowledgeBaseArn,
        knowledgeBaseId,
        lastModifiedBy.map(value => value),
        lastModifiedTime,
        name,
        quickResponseArn,
        quickResponseId,
        status,
        tags.map(value => value)
      )
    def channels: Optional[List[Channel]]
    def contentType: QuickResponseType
    def createdTime: SyntheticTimestamp_epoch_seconds
    def description: Optional[QuickResponseDescription]
    def isActive: Optional[Boolean]
    def knowledgeBaseArn: Arn
    def knowledgeBaseId: Uuid
    def lastModifiedBy: Optional[GenericArn]
    def lastModifiedTime: SyntheticTimestamp_epoch_seconds
    def name: QuickResponseName
    def quickResponseArn: Arn
    def quickResponseId: Uuid
    def status: zio.aws.wisdom.model.QuickResponseStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def getChannels: ZIO[Any, AwsError, List[Channel]] =
      AwsError.unwrapOptionField("channels", channels)
    def getContentType: ZIO[Any, Nothing, QuickResponseType] =
      ZIO.succeed(contentType)
    def getCreatedTime: ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, AwsError, QuickResponseDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
    def getKnowledgeBaseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(knowledgeBaseId)
    def getLastModifiedBy: ZIO[Any, AwsError, GenericArn] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedTime
        : ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(lastModifiedTime)
    def getName: ZIO[Any, Nothing, QuickResponseName] = ZIO.succeed(name)
    def getQuickResponseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(quickResponseArn)
    def getQuickResponseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(quickResponseId)
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.QuickResponseStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseSummary
  ) extends zio.aws.wisdom.model.QuickResponseSummary.ReadOnly {
    override val channels: Optional[List[Channel]] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.primitives.Channel(item)
        }.toList
      )
    override val contentType: QuickResponseType =
      zio.aws.wisdom.model.primitives.QuickResponseType(impl.contentType())
    override val createdTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.createdTime())
    override val description: Optional[QuickResponseDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.wisdom.model.primitives.QuickResponseDescription(value)
        )
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
    override val knowledgeBaseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.knowledgeBaseArn())
    override val knowledgeBaseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.knowledgeBaseId())
    override val lastModifiedBy: Optional[GenericArn] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => zio.aws.wisdom.model.primitives.GenericArn(value))
    override val lastModifiedTime: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.lastModifiedTime())
    override val name: QuickResponseName =
      zio.aws.wisdom.model.primitives.QuickResponseName(impl.name())
    override val quickResponseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.quickResponseArn())
    override val quickResponseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.quickResponseId())
    override val status: zio.aws.wisdom.model.QuickResponseStatus =
      zio.aws.wisdom.model.QuickResponseStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QuickResponseSummary
  ): zio.aws.wisdom.model.QuickResponseSummary.ReadOnly = new Wrapper(impl)
}
