package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class RemoveKnowledgeBaseTemplateUriRequest(
    knowledgeBaseId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest = {
    import RemoveKnowledgeBaseTemplateUriRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest
      .builder()
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest.ReadOnly =
    zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest
      .wrap(buildAwsValue())
}
object RemoveKnowledgeBaseTemplateUriRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest =
      zio.aws.wisdom.model
        .RemoveKnowledgeBaseTemplateUriRequest(knowledgeBaseId)
    def knowledgeBaseId: UuidOrArn
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest
  ) extends zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest.ReadOnly {
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest
  ): zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest.ReadOnly =
    new Wrapper(impl)
}
