package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  ContactAttributeValue,
  ContactAttributeKey,
  MaxResults,
  UuidOrArn,
  NonEmptyString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchQuickResponsesRequest(
    attributes: Optional[Map[ContactAttributeKey, ContactAttributeValue]] =
      Optional.Absent,
    knowledgeBaseId: UuidOrArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent,
    searchExpression: zio.aws.wisdom.model.QuickResponseSearchExpression
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesRequest = {
    import SearchQuickResponsesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesRequest
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (ContactAttributeKey.unwrap(
                key
              ): java.lang.String) -> (ContactAttributeValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .searchExpression(searchExpression.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SearchQuickResponsesRequest.ReadOnly =
    zio.aws.wisdom.model.SearchQuickResponsesRequest.wrap(buildAwsValue())
}
object SearchQuickResponsesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SearchQuickResponsesRequest =
      zio.aws.wisdom.model.SearchQuickResponsesRequest(
        attributes.map(value => value),
        knowledgeBaseId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        searchExpression.asEditable
      )
    def attributes: Optional[Map[ContactAttributeKey, ContactAttributeValue]]
    def knowledgeBaseId: UuidOrArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NonEmptyString]
    def searchExpression
        : zio.aws.wisdom.model.QuickResponseSearchExpression.ReadOnly
    def getAttributes
        : ZIO[Any, AwsError, Map[ContactAttributeKey, ContactAttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSearchExpression: ZIO[
      Any,
      Nothing,
      zio.aws.wisdom.model.QuickResponseSearchExpression.ReadOnly
    ] = ZIO.succeed(searchExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesRequest
  ) extends zio.aws.wisdom.model.SearchQuickResponsesRequest.ReadOnly {
    override val attributes
        : Optional[Map[ContactAttributeKey, ContactAttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.wisdom.model.primitives.ContactAttributeKey(
                key
              ) -> zio.aws.wisdom.model.primitives.ContactAttributeValue(value)
            })
            .toMap
        )
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
    override val searchExpression
        : zio.aws.wisdom.model.QuickResponseSearchExpression.ReadOnly =
      zio.aws.wisdom.model.QuickResponseSearchExpression
        .wrap(impl.searchExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesRequest
  ): zio.aws.wisdom.model.SearchQuickResponsesRequest.ReadOnly = new Wrapper(
    impl
  )
}
