package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class SearchQuickResponsesResponse(
    nextToken: Optional[NonEmptyString] = Optional.Absent,
    results: Iterable[zio.aws.wisdom.model.QuickResponseSearchResultData]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesResponse = {
    import SearchQuickResponsesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .results(results.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SearchQuickResponsesResponse.ReadOnly =
    zio.aws.wisdom.model.SearchQuickResponsesResponse.wrap(buildAwsValue())
}
object SearchQuickResponsesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SearchQuickResponsesResponse =
      zio.aws.wisdom.model.SearchQuickResponsesResponse(
        nextToken.map(value => value),
        results.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NonEmptyString]
    def results
        : List[zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResults: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly
    ]] = ZIO.succeed(results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesResponse
  ) extends zio.aws.wisdom.model.SearchQuickResponsesResponse.ReadOnly {
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
    override val results
        : List[zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly] =
      impl
        .results()
        .asScala
        .map { item =>
          zio.aws.wisdom.model.QuickResponseSearchResultData.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesResponse
  ): zio.aws.wisdom.model.SearchQuickResponsesResponse.ReadOnly = new Wrapper(
    impl
  )
}
