package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.GenericArn
import scala.jdk.CollectionConverters.*
final case class SessionIntegrationConfiguration(
    topicIntegrationArn: Optional[GenericArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SessionIntegrationConfiguration = {
    import SessionIntegrationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SessionIntegrationConfiguration
      .builder()
      .optionallyWith(
        topicIntegrationArn.map(value =>
          GenericArn.unwrap(value): java.lang.String
        )
      )(_.topicIntegrationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.SessionIntegrationConfiguration.ReadOnly =
    zio.aws.wisdom.model.SessionIntegrationConfiguration.wrap(buildAwsValue())
}
object SessionIntegrationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SessionIntegrationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SessionIntegrationConfiguration =
      zio.aws.wisdom.model.SessionIntegrationConfiguration(
        topicIntegrationArn.map(value => value)
      )
    def topicIntegrationArn: Optional[GenericArn]
    def getTopicIntegrationArn: ZIO[Any, AwsError, GenericArn] =
      AwsError.unwrapOptionField("topicIntegrationArn", topicIntegrationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SessionIntegrationConfiguration
  ) extends zio.aws.wisdom.model.SessionIntegrationConfiguration.ReadOnly {
    override val topicIntegrationArn: Optional[GenericArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicIntegrationArn())
        .map(value => zio.aws.wisdom.model.primitives.GenericArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SessionIntegrationConfiguration
  ): zio.aws.wisdom.model.SessionIntegrationConfiguration.ReadOnly =
    new Wrapper(impl)
}
