package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceConfiguration(
    appIntegrations: Optional[
      zio.aws.wisdom.model.AppIntegrationsConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SourceConfiguration = {
    import SourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SourceConfiguration
      .builder()
      .optionallyWith(appIntegrations.map(value => value.buildAwsValue()))(
        _.appIntegrations
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SourceConfiguration.ReadOnly =
    zio.aws.wisdom.model.SourceConfiguration.wrap(buildAwsValue())
}
object SourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SourceConfiguration =
      zio.aws.wisdom.model
        .SourceConfiguration(appIntegrations.map(value => value.asEditable))
    def appIntegrations
        : Optional[zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly]
    def getAppIntegrations: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("appIntegrations", appIntegrations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SourceConfiguration
  ) extends zio.aws.wisdom.model.SourceConfiguration.ReadOnly {
    override val appIntegrations
        : Optional[zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appIntegrations())
        .map(value =>
          zio.aws.wisdom.model.AppIntegrationsConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SourceConfiguration
  ): zio.aws.wisdom.model.SourceConfiguration.ReadOnly = new Wrapper(impl)
}
