package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{TimeToLive, UuidOrArn, ContentType}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartContentUploadRequest(
    contentType: ContentType,
    knowledgeBaseId: UuidOrArn,
    presignedUrlTimeToLive: Optional[TimeToLive] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest = {
    import StartContentUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest
      .builder()
      .contentType(ContentType.unwrap(contentType): java.lang.String)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        presignedUrlTimeToLive.map(value => TimeToLive.unwrap(value): Integer)
      )(_.presignedUrlTimeToLive)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.StartContentUploadRequest.ReadOnly =
    zio.aws.wisdom.model.StartContentUploadRequest.wrap(buildAwsValue())
}
object StartContentUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.StartContentUploadRequest =
      zio.aws.wisdom.model.StartContentUploadRequest(
        contentType,
        knowledgeBaseId,
        presignedUrlTimeToLive.map(value => value)
      )
    def contentType: ContentType
    def knowledgeBaseId: UuidOrArn
    def presignedUrlTimeToLive: Optional[TimeToLive]
    def getContentType: ZIO[Any, Nothing, ContentType] =
      ZIO.succeed(contentType)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getPresignedUrlTimeToLive: ZIO[Any, AwsError, TimeToLive] = AwsError
      .unwrapOptionField("presignedUrlTimeToLive", presignedUrlTimeToLive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest
  ) extends zio.aws.wisdom.model.StartContentUploadRequest.ReadOnly {
    override val contentType: ContentType =
      zio.aws.wisdom.model.primitives.ContentType(impl.contentType())
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val presignedUrlTimeToLive: Optional[TimeToLive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presignedUrlTimeToLive())
        .map(value => zio.aws.wisdom.model.primitives.TimeToLive(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest
  ): zio.aws.wisdom.model.StartContentUploadRequest.ReadOnly = new Wrapper(impl)
}
