package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{UploadId, UuidOrArn, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class StartImportJobRequest(
    clientToken: Optional[NonEmptyString] = Optional.Absent,
    externalSourceConfiguration: Optional[
      zio.aws.wisdom.model.ExternalSourceConfiguration
    ] = Optional.Absent,
    importJobType: zio.aws.wisdom.model.ImportJobType,
    knowledgeBaseId: UuidOrArn,
    metadata: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    uploadId: UploadId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.StartImportJobRequest = {
    import StartImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.StartImportJobRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        externalSourceConfiguration.map(value => value.buildAwsValue())
      )(_.externalSourceConfiguration)
      .importJobType(importJobType.unwrap)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.StartImportJobRequest.ReadOnly =
    zio.aws.wisdom.model.StartImportJobRequest.wrap(buildAwsValue())
}
object StartImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.StartImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.StartImportJobRequest =
      zio.aws.wisdom.model.StartImportJobRequest(
        clientToken.map(value => value),
        externalSourceConfiguration.map(value => value.asEditable),
        importJobType,
        knowledgeBaseId,
        metadata.map(value => value),
        uploadId
      )
    def clientToken: Optional[NonEmptyString]
    def externalSourceConfiguration
        : Optional[zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly]
    def importJobType: zio.aws.wisdom.model.ImportJobType
    def knowledgeBaseId: UuidOrArn
    def metadata: Optional[Map[NonEmptyString, NonEmptyString]]
    def uploadId: UploadId
    def getClientToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExternalSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalSourceConfiguration",
      externalSourceConfiguration
    )
    def getImportJobType
        : ZIO[Any, Nothing, zio.aws.wisdom.model.ImportJobType] =
      ZIO.succeed(importJobType)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getMetadata: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.StartImportJobRequest
  ) extends zio.aws.wisdom.model.StartImportJobRequest.ReadOnly {
    override val clientToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
    override val externalSourceConfiguration
        : Optional[zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalSourceConfiguration())
        .map(value =>
          zio.aws.wisdom.model.ExternalSourceConfiguration.wrap(value)
        )
    override val importJobType: zio.aws.wisdom.model.ImportJobType =
      zio.aws.wisdom.model.ImportJobType.wrap(impl.importJobType())
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val metadata: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.wisdom.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.wisdom.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val uploadId: UploadId =
      zio.aws.wisdom.model.primitives.UploadId(impl.uploadId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.StartImportJobRequest
  ): zio.aws.wisdom.model.StartImportJobRequest.ReadOnly = new Wrapper(impl)
}
