package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateContentResponse(
    content: Optional[zio.aws.wisdom.model.ContentData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.UpdateContentResponse = {
    import UpdateContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.UpdateContentResponse
      .builder()
      .optionallyWith(content.map(value => value.buildAwsValue()))(_.content)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.UpdateContentResponse.ReadOnly =
    zio.aws.wisdom.model.UpdateContentResponse.wrap(buildAwsValue())
}
object UpdateContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.UpdateContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.UpdateContentResponse =
      zio.aws.wisdom.model
        .UpdateContentResponse(content.map(value => value.asEditable))
    def content: Optional[zio.aws.wisdom.model.ContentData.ReadOnly]
    def getContent
        : ZIO[Any, AwsError, zio.aws.wisdom.model.ContentData.ReadOnly] =
      AwsError.unwrapOptionField("content", content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateContentResponse
  ) extends zio.aws.wisdom.model.UpdateContentResponse.ReadOnly {
    override val content: Optional[zio.aws.wisdom.model.ContentData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value => zio.aws.wisdom.model.ContentData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateContentResponse
  ): zio.aws.wisdom.model.UpdateContentResponse.ReadOnly = new Wrapper(impl)
}
