package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateKnowledgeBaseTemplateUriResponse(
    knowledgeBase: Optional[zio.aws.wisdom.model.KnowledgeBaseData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse = {
    import UpdateKnowledgeBaseTemplateUriResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse
      .builder()
      .optionallyWith(knowledgeBase.map(value => value.buildAwsValue()))(
        _.knowledgeBase
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.ReadOnly =
    zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse
      .wrap(buildAwsValue())
}
object UpdateKnowledgeBaseTemplateUriResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse =
      zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse(
        knowledgeBase.map(value => value.asEditable)
      )
    def knowledgeBase: Optional[zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly]
    def getKnowledgeBase
        : ZIO[Any, AwsError, zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly] =
      AwsError.unwrapOptionField("knowledgeBase", knowledgeBase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse
  ) extends zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.ReadOnly {
    override val knowledgeBase
        : Optional[zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.knowledgeBase())
        .map(value => zio.aws.wisdom.model.KnowledgeBaseData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse
  ): zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.ReadOnly =
    new Wrapper(impl)
}
