package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  QuickResponseName,
  LanguageCode,
  QuickResponseType,
  ShortCutKey,
  Channel,
  QuickResponseDescription,
  UuidOrArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateQuickResponseRequest(
    channels: Optional[Iterable[Channel]] = Optional.Absent,
    content: Optional[zio.aws.wisdom.model.QuickResponseDataProvider] =
      Optional.Absent,
    contentType: Optional[QuickResponseType] = Optional.Absent,
    description: Optional[QuickResponseDescription] = Optional.Absent,
    groupingConfiguration: Optional[
      zio.aws.wisdom.model.GroupingConfiguration
    ] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent,
    knowledgeBaseId: UuidOrArn,
    language: Optional[LanguageCode] = Optional.Absent,
    name: Optional[QuickResponseName] = Optional.Absent,
    quickResponseId: UuidOrArn,
    removeDescription: Optional[Boolean] = Optional.Absent,
    removeGroupingConfiguration: Optional[Boolean] = Optional.Absent,
    removeShortcutKey: Optional[Boolean] = Optional.Absent,
    shortcutKey: Optional[ShortCutKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseRequest = {
    import UpdateQuickResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseRequest
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            Channel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(content.map(value => value.buildAwsValue()))(_.content)
      .optionallyWith(
        contentType.map(value =>
          QuickResponseType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        description.map(value =>
          QuickResponseDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        groupingConfiguration.map(value => value.buildAwsValue())
      )(_.groupingConfiguration)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        language.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        name.map(value => QuickResponseName.unwrap(value): java.lang.String)
      )(_.name)
      .quickResponseId(UuidOrArn.unwrap(quickResponseId): java.lang.String)
      .optionallyWith(removeDescription.map(value => value: java.lang.Boolean))(
        _.removeDescription
      )
      .optionallyWith(
        removeGroupingConfiguration.map(value => value: java.lang.Boolean)
      )(_.removeGroupingConfiguration)
      .optionallyWith(removeShortcutKey.map(value => value: java.lang.Boolean))(
        _.removeShortcutKey
      )
      .optionallyWith(
        shortcutKey.map(value => ShortCutKey.unwrap(value): java.lang.String)
      )(_.shortcutKey)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.UpdateQuickResponseRequest.ReadOnly =
    zio.aws.wisdom.model.UpdateQuickResponseRequest.wrap(buildAwsValue())
}
object UpdateQuickResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.UpdateQuickResponseRequest =
      zio.aws.wisdom.model.UpdateQuickResponseRequest(
        channels.map(value => value),
        content.map(value => value.asEditable),
        contentType.map(value => value),
        description.map(value => value),
        groupingConfiguration.map(value => value.asEditable),
        isActive.map(value => value),
        knowledgeBaseId,
        language.map(value => value),
        name.map(value => value),
        quickResponseId,
        removeDescription.map(value => value),
        removeGroupingConfiguration.map(value => value),
        removeShortcutKey.map(value => value),
        shortcutKey.map(value => value)
      )
    def channels: Optional[List[Channel]]
    def content
        : Optional[zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly]
    def contentType: Optional[QuickResponseType]
    def description: Optional[QuickResponseDescription]
    def groupingConfiguration
        : Optional[zio.aws.wisdom.model.GroupingConfiguration.ReadOnly]
    def isActive: Optional[Boolean]
    def knowledgeBaseId: UuidOrArn
    def language: Optional[LanguageCode]
    def name: Optional[QuickResponseName]
    def quickResponseId: UuidOrArn
    def removeDescription: Optional[Boolean]
    def removeGroupingConfiguration: Optional[Boolean]
    def removeShortcutKey: Optional[Boolean]
    def shortcutKey: Optional[ShortCutKey]
    def getChannels: ZIO[Any, AwsError, List[Channel]] =
      AwsError.unwrapOptionField("channels", channels)
    def getContent: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly
    ] = AwsError.unwrapOptionField("content", content)
    def getContentType: ZIO[Any, AwsError, QuickResponseType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDescription: ZIO[Any, AwsError, QuickResponseDescription] =
      AwsError.unwrapOptionField("description", description)
    def getGroupingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.GroupingConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("groupingConfiguration", groupingConfiguration)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getLanguage: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("language", language)
    def getName: ZIO[Any, AwsError, QuickResponseName] =
      AwsError.unwrapOptionField("name", name)
    def getQuickResponseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(quickResponseId)
    def getRemoveDescription: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("removeDescription", removeDescription)
    def getRemoveGroupingConfiguration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "removeGroupingConfiguration",
        removeGroupingConfiguration
      )
    def getRemoveShortcutKey: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("removeShortcutKey", removeShortcutKey)
    def getShortcutKey: ZIO[Any, AwsError, ShortCutKey] =
      AwsError.unwrapOptionField("shortcutKey", shortcutKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseRequest
  ) extends zio.aws.wisdom.model.UpdateQuickResponseRequest.ReadOnly {
    override val channels: Optional[List[Channel]] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.primitives.Channel(item)
        }.toList
      )
    override val content
        : Optional[zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value =>
          zio.aws.wisdom.model.QuickResponseDataProvider.wrap(value)
        )
    override val contentType: Optional[QuickResponseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value => zio.aws.wisdom.model.primitives.QuickResponseType(value))
    override val description: Optional[QuickResponseDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.wisdom.model.primitives.QuickResponseDescription(value)
        )
    override val groupingConfiguration
        : Optional[zio.aws.wisdom.model.GroupingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupingConfiguration())
        .map(value => zio.aws.wisdom.model.GroupingConfiguration.wrap(value))
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val language: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.wisdom.model.primitives.LanguageCode(value))
    override val name: Optional[QuickResponseName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wisdom.model.primitives.QuickResponseName(value))
    override val quickResponseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.quickResponseId())
    override val removeDescription: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.removeDescription())
      .map(value => value: Boolean)
    override val removeGroupingConfiguration: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeGroupingConfiguration())
        .map(value => value: Boolean)
    override val removeShortcutKey: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.removeShortcutKey())
      .map(value => value: Boolean)
    override val shortcutKey: Optional[ShortCutKey] = zio.aws.core.internal
      .optionalFromNullable(impl.shortcutKey())
      .map(value => zio.aws.wisdom.model.primitives.ShortCutKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseRequest
  ): zio.aws.wisdom.model.UpdateQuickResponseRequest.ReadOnly = new Wrapper(
    impl
  )
}
