package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateQuickResponseResponse(
    quickResponse: Optional[zio.aws.wisdom.model.QuickResponseData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseResponse = {
    import UpdateQuickResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseResponse
      .builder()
      .optionallyWith(quickResponse.map(value => value.buildAwsValue()))(
        _.quickResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.UpdateQuickResponseResponse.ReadOnly =
    zio.aws.wisdom.model.UpdateQuickResponseResponse.wrap(buildAwsValue())
}
object UpdateQuickResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.UpdateQuickResponseResponse =
      zio.aws.wisdom.model.UpdateQuickResponseResponse(
        quickResponse.map(value => value.asEditable)
      )
    def quickResponse: Optional[zio.aws.wisdom.model.QuickResponseData.ReadOnly]
    def getQuickResponse
        : ZIO[Any, AwsError, zio.aws.wisdom.model.QuickResponseData.ReadOnly] =
      AwsError.unwrapOptionField("quickResponse", quickResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseResponse
  ) extends zio.aws.wisdom.model.UpdateQuickResponseResponse.ReadOnly {
    override val quickResponse
        : Optional[zio.aws.wisdom.model.QuickResponseData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickResponse())
        .map(value => zio.aws.wisdom.model.QuickResponseData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateQuickResponseResponse
  ): zio.aws.wisdom.model.UpdateQuickResponseResponse.ReadOnly = new Wrapper(
    impl
  )
}
