package zio.aws.wisdom
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.wisdom.model.primitives.Channel.Type
import zio.aws.wisdom.model.primitives.{
  QuickResponseQueryValue,
  TagValue,
  ContactAttributeValue,
  QuickResponseFilterValue,
  GroupingValue,
  ContactAttributeKey,
  Channel,
  NonEmptyString,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.wisdom.model.primitives.Arn.Type
    object Channel extends zio.prelude.Subtype[String]
    type Channel = zio.aws.wisdom.model.primitives.Channel.Type
    object ClientToken extends zio.prelude.Subtype[String]
    type ClientToken = zio.aws.wisdom.model.primitives.ClientToken.Type
    object ContactAttributeKey extends zio.prelude.Subtype[String]
    type ContactAttributeKey =
      zio.aws.wisdom.model.primitives.ContactAttributeKey.Type
    object ContactAttributeValue extends zio.prelude.Subtype[String]
    type ContactAttributeValue =
      zio.aws.wisdom.model.primitives.ContactAttributeValue.Type
    object ContentTitle extends zio.prelude.Subtype[String]
    type ContentTitle = zio.aws.wisdom.model.primitives.ContentTitle.Type
    object ContentType extends zio.prelude.Subtype[String]
    type ContentType = zio.aws.wisdom.model.primitives.ContentType.Type
    object Description extends zio.prelude.Subtype[String]
    type Description = zio.aws.wisdom.model.primitives.Description.Type
    object GenericArn extends zio.prelude.Subtype[String]
    type GenericArn = zio.aws.wisdom.model.primitives.GenericArn.Type
    object GroupingCriteria extends zio.prelude.Subtype[String]
    type GroupingCriteria =
      zio.aws.wisdom.model.primitives.GroupingCriteria.Type
    object GroupingValue extends zio.prelude.Subtype[String]
    type GroupingValue = zio.aws.wisdom.model.primitives.GroupingValue.Type
    object HighlightOffset extends zio.prelude.Subtype[Int]
    type HighlightOffset = zio.aws.wisdom.model.primitives.HighlightOffset.Type
    object LanguageCode extends zio.prelude.Subtype[String]
    type LanguageCode = zio.aws.wisdom.model.primitives.LanguageCode.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.wisdom.model.primitives.MaxResults.Type
    object Name extends zio.prelude.Subtype[String]
    type Name = zio.aws.wisdom.model.primitives.Name.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.wisdom.model.primitives.NextToken.Type
    object NonEmptyString extends zio.prelude.Subtype[String]
    type NonEmptyString = zio.aws.wisdom.model.primitives.NonEmptyString.Type
    object NotifyRecommendationsReceivedErrorMessage
        extends zio.prelude.Subtype[String]
    type NotifyRecommendationsReceivedErrorMessage =
      zio.aws.wisdom.model.primitives.NotifyRecommendationsReceivedErrorMessage.Type
    object QuickResponseContent extends zio.prelude.Subtype[String]
    type QuickResponseContent =
      zio.aws.wisdom.model.primitives.QuickResponseContent.Type
    object QuickResponseDescription extends zio.prelude.Subtype[String]
    type QuickResponseDescription =
      zio.aws.wisdom.model.primitives.QuickResponseDescription.Type
    object QuickResponseFilterValue extends zio.prelude.Subtype[String]
    type QuickResponseFilterValue =
      zio.aws.wisdom.model.primitives.QuickResponseFilterValue.Type
    object QuickResponseName extends zio.prelude.Subtype[String]
    type QuickResponseName =
      zio.aws.wisdom.model.primitives.QuickResponseName.Type
    object QuickResponseQueryValue extends zio.prelude.Subtype[String]
    type QuickResponseQueryValue =
      zio.aws.wisdom.model.primitives.QuickResponseQueryValue.Type
    object QuickResponseType extends zio.prelude.Subtype[String]
    type QuickResponseType =
      zio.aws.wisdom.model.primitives.QuickResponseType.Type
    object RelevanceScore extends zio.prelude.Subtype[Double]
    type RelevanceScore = zio.aws.wisdom.model.primitives.RelevanceScore.Type
    object SensitiveString extends zio.prelude.Subtype[String]
    type SensitiveString = zio.aws.wisdom.model.primitives.SensitiveString.Type
    object ShortCutKey extends zio.prelude.Subtype[String]
    type ShortCutKey = zio.aws.wisdom.model.primitives.ShortCutKey.Type
    object SyntheticTimestamp_epoch_seconds extends zio.prelude.Subtype[Instant]
    type SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives.SyntheticTimestamp_epoch_seconds.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.wisdom.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.wisdom.model.primitives.TagValue.Type
    object TimeToLive extends zio.prelude.Subtype[Int]
    type TimeToLive = zio.aws.wisdom.model.primitives.TimeToLive.Type
    object UploadId extends zio.prelude.Subtype[String]
    type UploadId = zio.aws.wisdom.model.primitives.UploadId.Type
    object Uri extends zio.prelude.Subtype[String]
    type Uri = zio.aws.wisdom.model.primitives.Uri.Type
    object Url extends zio.prelude.Subtype[String]
    type Url = zio.aws.wisdom.model.primitives.Url.Type
    object Uuid extends zio.prelude.Subtype[String]
    type Uuid = zio.aws.wisdom.model.primitives.Uuid.Type
    object UuidOrArn extends zio.prelude.Subtype[String]
    type UuidOrArn = zio.aws.wisdom.model.primitives.UuidOrArn.Type
  }
  type AssistantAssociationSummaryList =
    List[zio.aws.wisdom.model.AssistantAssociationSummary]
  type AssistantList = List[zio.aws.wisdom.model.AssistantSummary]
  type Channels = List[Channel]
  type ContactAttributeKeys = List[ContactAttributeKey]
  type ContactAttributes = Map[ContactAttributeKey, ContactAttributeValue]
  type ContentMetadata = Map[NonEmptyString, NonEmptyString]
  type ContentSummaryList = List[zio.aws.wisdom.model.ContentSummary]
  type FilterList = List[zio.aws.wisdom.model.Filter]
  type GroupingValues = List[GroupingValue]
  type Headers = Map[NonEmptyString, NonEmptyString]
  type Highlights = List[zio.aws.wisdom.model.Highlight]
  type ImportJobList = List[zio.aws.wisdom.model.ImportJobSummary]
  type KnowledgeBaseList = List[zio.aws.wisdom.model.KnowledgeBaseSummary]
  type NotifyRecommendationsReceivedErrorList =
    List[zio.aws.wisdom.model.NotifyRecommendationsReceivedError]
  type ObjectFieldsList = List[NonEmptyString]
  type QuickResponseFilterFieldList =
    List[zio.aws.wisdom.model.QuickResponseFilterField]
  type QuickResponseFilterValueList = List[QuickResponseFilterValue]
  type QuickResponseQueryFieldList =
    List[zio.aws.wisdom.model.QuickResponseQueryField]
  type QuickResponseQueryValueList = List[QuickResponseQueryValue]
  type QuickResponseSearchResultsList =
    List[zio.aws.wisdom.model.QuickResponseSearchResultData]
  type QuickResponseSummaryList =
    List[zio.aws.wisdom.model.QuickResponseSummary]
  type RecommendationIdList = List[String]
  type SessionSummaries = List[zio.aws.wisdom.model.SessionSummary]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
}
