package zio.aws.xray
import zio.aws.xray.model.GetInsightResponse.ReadOnly
import software.amazon.awssdk.services.xray.paginators.BatchGetTracesPublisher
import zio.aws.core.config.AwsConfig
import zio.aws.xray.model.{
  GetEncryptionConfigRequest,
  GetTraceGraphRequest,
  BatchGetTracesRequest,
  PutEncryptionConfigRequest,
  GetGroupRequest,
  GetGroupsRequest,
  UpdateGroupRequest,
  CreateSamplingRuleRequest,
  GetInsightEventsRequest,
  ListTagsForResourceRequest,
  DeleteGroupRequest,
  GetServiceGraphRequest,
  GetSamplingRulesRequest,
  GetInsightImpactGraphRequest,
  GetInsightSummariesRequest,
  GetTraceSummariesRequest,
  DeleteSamplingRuleRequest,
  UntagResourceRequest,
  CreateGroupRequest,
  PutTelemetryRecordsRequest,
  GetSamplingStatisticSummariesRequest,
  GetSamplingTargetsRequest,
  GetTimeSeriesServiceStatisticsRequest,
  PutTraceSegmentsRequest,
  GetInsightRequest,
  UpdateSamplingRuleRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.xray.model.{
  DeleteGroupResponse,
  PutTraceSegmentsResponse,
  InsightSummary,
  GetInsightResponse,
  UpdateSamplingRuleResponse,
  DeleteSamplingRuleResponse,
  GetTimeSeriesServiceStatisticsResponse,
  GetInsightSummariesResponse,
  GetTraceSummariesResponse,
  CreateSamplingRuleResponse,
  TimeSeriesServiceStatistics,
  SamplingStatisticSummary,
  GroupSummary,
  GetGroupsResponse,
  Tag,
  GetServiceGraphResponse,
  GetInsightImpactGraphResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  Service,
  InsightImpactGraphService,
  GetSamplingStatisticSummariesResponse,
  TraceSummary,
  InsightEvent,
  CreateGroupResponse,
  PutTelemetryRecordsResponse,
  BatchGetTracesResponse,
  GetSamplingRulesResponse,
  SamplingRuleRecord,
  Trace,
  GetSamplingTargetsResponse,
  TagResourceResponse,
  PutEncryptionConfigResponse,
  GetInsightEventsResponse,
  GetGroupResponse,
  GetEncryptionConfigResponse,
  GetTraceGraphResponse,
  UpdateGroupResponse
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.xray.{
  XRayAsyncClientBuilder,
  XRayAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait XRay extends AspectSupport[XRay] {
  val api: XRayAsyncClient
  def getInsightEvents(
      request: GetInsightEventsRequest
  ): ZStream[Any, AwsError, zio.aws.xray.model.InsightEvent.ReadOnly]
  def getInsightEventsPaginated(
      request: GetInsightEventsRequest
  ): IO[AwsError, zio.aws.xray.model.GetInsightEventsResponse.ReadOnly]
  def getServiceGraph(
      request: GetServiceGraphRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.xray.model.GetServiceGraphResponse.ReadOnly,
    zio.aws.xray.model.Service.ReadOnly
  ]]
  def getServiceGraphPaginated(
      request: GetServiceGraphRequest
  ): IO[AwsError, zio.aws.xray.model.GetServiceGraphResponse.ReadOnly]
  def batchGetTraces(
      request: BatchGetTracesRequest
  ): ZStream[Any, AwsError, zio.aws.xray.model.Trace.ReadOnly]
  def batchGetTracesPaginated(
      request: BatchGetTracesRequest
  ): IO[AwsError, zio.aws.xray.model.BatchGetTracesResponse.ReadOnly]
  def getTimeSeriesServiceStatistics(
      request: GetTimeSeriesServiceStatisticsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly,
    zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly
  ]]
  def getTimeSeriesServiceStatisticsPaginated(
      request: GetTimeSeriesServiceStatisticsRequest
  ): IO[
    AwsError,
    zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly
  ]
  def deleteGroup(
      request: DeleteGroupRequest
  ): IO[AwsError, zio.aws.xray.model.DeleteGroupResponse.ReadOnly]
  def getTraceGraph(
      request: GetTraceGraphRequest
  ): ZStream[Any, AwsError, zio.aws.xray.model.Service.ReadOnly]
  def getTraceGraphPaginated(
      request: GetTraceGraphRequest
  ): IO[AwsError, zio.aws.xray.model.GetTraceGraphResponse.ReadOnly]
  def getSamplingStatisticSummaries(
      request: GetSamplingStatisticSummariesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.xray.model.SamplingStatisticSummary.ReadOnly
  ]
  def getSamplingStatisticSummariesPaginated(
      request: GetSamplingStatisticSummariesRequest
  ): IO[
    AwsError,
    zio.aws.xray.model.GetSamplingStatisticSummariesResponse.ReadOnly
  ]
  def putTelemetryRecords(
      request: PutTelemetryRecordsRequest
  ): IO[AwsError, zio.aws.xray.model.PutTelemetryRecordsResponse.ReadOnly]
  def createSamplingRule(
      request: CreateSamplingRuleRequest
  ): IO[AwsError, zio.aws.xray.model.CreateSamplingRuleResponse.ReadOnly]
  def updateSamplingRule(
      request: UpdateSamplingRuleRequest
  ): IO[AwsError, zio.aws.xray.model.UpdateSamplingRuleResponse.ReadOnly]
  def getInsightImpactGraph(
      request: GetInsightImpactGraphRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly,
    zio.aws.xray.model.InsightImpactGraphService.ReadOnly
  ]]
  def getInsightImpactGraphPaginated(
      request: GetInsightImpactGraphRequest
  ): IO[AwsError, zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly]
  def deleteSamplingRule(
      request: DeleteSamplingRuleRequest
  ): IO[AwsError, zio.aws.xray.model.DeleteSamplingRuleResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.xray.model.UntagResourceResponse.ReadOnly]
  def getSamplingTargets(
      request: GetSamplingTargetsRequest
  ): IO[AwsError, zio.aws.xray.model.GetSamplingTargetsResponse.ReadOnly]
  def putEncryptionConfig(
      request: PutEncryptionConfigRequest
  ): IO[AwsError, zio.aws.xray.model.PutEncryptionConfigResponse.ReadOnly]
  def createGroup(
      request: CreateGroupRequest
  ): IO[AwsError, zio.aws.xray.model.CreateGroupResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.xray.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.xray.model.ListTagsForResourceResponse.ReadOnly]
  def updateGroup(
      request: UpdateGroupRequest
  ): IO[AwsError, zio.aws.xray.model.UpdateGroupResponse.ReadOnly]
  def getTraceSummaries(
      request: GetTraceSummariesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly,
    zio.aws.xray.model.TraceSummary.ReadOnly
  ]]
  def getTraceSummariesPaginated(
      request: GetTraceSummariesRequest
  ): IO[AwsError, zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.xray.model.TagResourceResponse.ReadOnly]
  def getGroup(
      request: GetGroupRequest
  ): IO[AwsError, zio.aws.xray.model.GetGroupResponse.ReadOnly]
  def getInsight(request: GetInsightRequest): IO[AwsError, ReadOnly]
  def getEncryptionConfig(
      request: GetEncryptionConfigRequest
  ): IO[AwsError, zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly]
  def putTraceSegments(
      request: PutTraceSegmentsRequest
  ): IO[AwsError, zio.aws.xray.model.PutTraceSegmentsResponse.ReadOnly]
  def getSamplingRules(
      request: GetSamplingRulesRequest
  ): ZStream[Any, AwsError, zio.aws.xray.model.SamplingRuleRecord.ReadOnly]
  def getSamplingRulesPaginated(
      request: GetSamplingRulesRequest
  ): IO[AwsError, zio.aws.xray.model.GetSamplingRulesResponse.ReadOnly]
  def getInsightSummaries(
      request: GetInsightSummariesRequest
  ): ZStream[Any, AwsError, zio.aws.xray.model.InsightSummary.ReadOnly]
  def getInsightSummariesPaginated(
      request: GetInsightSummariesRequest
  ): IO[AwsError, zio.aws.xray.model.GetInsightSummariesResponse.ReadOnly]
  def getGroups(
      request: GetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.xray.model.GroupSummary.ReadOnly]
  def getGroupsPaginated(
      request: GetGroupsRequest
  ): IO[AwsError, zio.aws.xray.model.GetGroupsResponse.ReadOnly]
}
object XRay {
  val live: ZLayer[AwsConfig, java.lang.Throwable, XRay] = customized(identity)
  def customized(
      customization: XRayAsyncClientBuilder => XRayAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, XRay] = managed(
    customization
  ).toLayer
  def managed(
      customization: XRayAsyncClientBuilder => XRayAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, XRay] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = XRayAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[XRayAsyncClient, XRayAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[XRayAsyncClient, XRayAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new XRayImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class XRayImpl[R](
      override val api: XRayAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends XRay
      with AwsServiceBase[R] {
    override val serviceName: String = "XRay"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): XRayImpl[R1] = new XRayImpl(api, newAspect, r)
    def getInsightEvents(
        request: GetInsightEventsRequest
    ): ZStream[Any, AwsError, zio.aws.xray.model.InsightEvent.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.xray.model.GetInsightEventsRequest,
        GetInsightEventsResponse,
        InsightEvent
      ](
        "getInsightEvents",
        api.getInsightEvents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.insightEvents().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.xray.model.InsightEvent.wrap(item))
        .provideEnvironment(r)
    def getInsightEventsPaginated(
        request: GetInsightEventsRequest
    ): IO[AwsError, zio.aws.xray.model.GetInsightEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetInsightEventsRequest,
        GetInsightEventsResponse
      ]("getInsightEvents", api.getInsightEvents)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetInsightEventsResponse.wrap)
        .provideEnvironment(r)
    def getServiceGraph(
        request: GetServiceGraphRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.xray.model.GetServiceGraphResponse.ReadOnly,
      zio.aws.xray.model.Service.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.xray.model.GetServiceGraphRequest,
      GetServiceGraphResponse,
      Service
    ](
      "getServiceGraph",
      api.getServiceGraph,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.services().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.xray.model.GetServiceGraphResponse.wrap)
          .mapOutput(_.map(item => zio.aws.xray.model.Service.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getServiceGraphPaginated(
        request: GetServiceGraphRequest
    ): IO[AwsError, zio.aws.xray.model.GetServiceGraphResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetServiceGraphRequest,
        GetServiceGraphResponse
      ]("getServiceGraph", api.getServiceGraph)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetServiceGraphResponse.wrap)
        .provideEnvironment(r)
    def batchGetTraces(
        request: BatchGetTracesRequest
    ): ZStream[Any, AwsError, zio.aws.xray.model.Trace.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.xray.model.BatchGetTracesRequest,
        Trace,
        BatchGetTracesPublisher
      ]("batchGetTraces", api.batchGetTracesPaginator, _.traces())(
        request.buildAwsValue()
      ).map(item => zio.aws.xray.model.Trace.wrap(item)).provideEnvironment(r)
    def batchGetTracesPaginated(
        request: BatchGetTracesRequest
    ): IO[AwsError, zio.aws.xray.model.BatchGetTracesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.BatchGetTracesRequest,
        BatchGetTracesResponse
      ]("batchGetTraces", api.batchGetTraces)(request.buildAwsValue())
        .map(zio.aws.xray.model.BatchGetTracesResponse.wrap)
        .provideEnvironment(r)
    def getTimeSeriesServiceStatistics(
        request: GetTimeSeriesServiceStatisticsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly,
      zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest,
      GetTimeSeriesServiceStatisticsResponse,
      TimeSeriesServiceStatistics
    ](
      "getTimeSeriesServiceStatistics",
      api.getTimeSeriesServiceStatistics,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.timeSeriesServiceStatistics().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.xray.model.TimeSeriesServiceStatistics.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getTimeSeriesServiceStatisticsPaginated(
        request: GetTimeSeriesServiceStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest,
      GetTimeSeriesServiceStatisticsResponse
    ]("getTimeSeriesServiceStatistics", api.getTimeSeriesServiceStatistics)(
      request.buildAwsValue()
    ).map(zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.wrap)
      .provideEnvironment(r)
    def deleteGroup(
        request: DeleteGroupRequest
    ): IO[AwsError, zio.aws.xray.model.DeleteGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.DeleteGroupRequest,
        DeleteGroupResponse
      ]("deleteGroup", api.deleteGroup)(request.buildAwsValue())
        .map(zio.aws.xray.model.DeleteGroupResponse.wrap)
        .provideEnvironment(r)
    def getTraceGraph(
        request: GetTraceGraphRequest
    ): ZStream[Any, AwsError, zio.aws.xray.model.Service.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.xray.model.GetTraceGraphRequest,
        GetTraceGraphResponse,
        Service
      ](
        "getTraceGraph",
        api.getTraceGraph,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.services().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.xray.model.Service.wrap(item))
        .provideEnvironment(r)
    def getTraceGraphPaginated(
        request: GetTraceGraphRequest
    ): IO[AwsError, zio.aws.xray.model.GetTraceGraphResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetTraceGraphRequest,
        GetTraceGraphResponse
      ]("getTraceGraph", api.getTraceGraph)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetTraceGraphResponse.wrap)
        .provideEnvironment(r)
    def getSamplingStatisticSummaries(
        request: GetSamplingStatisticSummariesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.xray.model.SamplingStatisticSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest,
      GetSamplingStatisticSummariesResponse,
      SamplingStatisticSummary
    ](
      "getSamplingStatisticSummaries",
      api.getSamplingStatisticSummaries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.samplingStatisticSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.xray.model.SamplingStatisticSummary.wrap(item))
      .provideEnvironment(r)
    def getSamplingStatisticSummariesPaginated(
        request: GetSamplingStatisticSummariesRequest
    ): IO[
      AwsError,
      zio.aws.xray.model.GetSamplingStatisticSummariesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest,
      GetSamplingStatisticSummariesResponse
    ]("getSamplingStatisticSummaries", api.getSamplingStatisticSummaries)(
      request.buildAwsValue()
    ).map(zio.aws.xray.model.GetSamplingStatisticSummariesResponse.wrap)
      .provideEnvironment(r)
    def putTelemetryRecords(
        request: PutTelemetryRecordsRequest
    ): IO[AwsError, zio.aws.xray.model.PutTelemetryRecordsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest,
        PutTelemetryRecordsResponse
      ]("putTelemetryRecords", api.putTelemetryRecords)(request.buildAwsValue())
        .map(zio.aws.xray.model.PutTelemetryRecordsResponse.wrap)
        .provideEnvironment(r)
    def createSamplingRule(
        request: CreateSamplingRuleRequest
    ): IO[AwsError, zio.aws.xray.model.CreateSamplingRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest,
        CreateSamplingRuleResponse
      ]("createSamplingRule", api.createSamplingRule)(request.buildAwsValue())
        .map(zio.aws.xray.model.CreateSamplingRuleResponse.wrap)
        .provideEnvironment(r)
    def updateSamplingRule(
        request: UpdateSamplingRuleRequest
    ): IO[AwsError, zio.aws.xray.model.UpdateSamplingRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest,
        UpdateSamplingRuleResponse
      ]("updateSamplingRule", api.updateSamplingRule)(request.buildAwsValue())
        .map(zio.aws.xray.model.UpdateSamplingRuleResponse.wrap)
        .provideEnvironment(r)
    def getInsightImpactGraph(
        request: GetInsightImpactGraphRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly,
      zio.aws.xray.model.InsightImpactGraphService.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest,
      GetInsightImpactGraphResponse,
      InsightImpactGraphService
    ](
      "getInsightImpactGraph",
      api.getInsightImpactGraph,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.services().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.xray.model.GetInsightImpactGraphResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.xray.model.InsightImpactGraphService.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getInsightImpactGraphPaginated(
        request: GetInsightImpactGraphRequest
    ): IO[AwsError, zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest,
        GetInsightImpactGraphResponse
      ]("getInsightImpactGraph", api.getInsightImpactGraph)(
        request.buildAwsValue()
      ).map(zio.aws.xray.model.GetInsightImpactGraphResponse.wrap)
        .provideEnvironment(r)
    def deleteSamplingRule(
        request: DeleteSamplingRuleRequest
    ): IO[AwsError, zio.aws.xray.model.DeleteSamplingRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest,
        DeleteSamplingRuleResponse
      ]("deleteSamplingRule", api.deleteSamplingRule)(request.buildAwsValue())
        .map(zio.aws.xray.model.DeleteSamplingRuleResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.xray.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.xray.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getSamplingTargets(
        request: GetSamplingTargetsRequest
    ): IO[AwsError, zio.aws.xray.model.GetSamplingTargetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest,
        GetSamplingTargetsResponse
      ]("getSamplingTargets", api.getSamplingTargets)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetSamplingTargetsResponse.wrap)
        .provideEnvironment(r)
    def putEncryptionConfig(
        request: PutEncryptionConfigRequest
    ): IO[AwsError, zio.aws.xray.model.PutEncryptionConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest,
        PutEncryptionConfigResponse
      ]("putEncryptionConfig", api.putEncryptionConfig)(request.buildAwsValue())
        .map(zio.aws.xray.model.PutEncryptionConfigResponse.wrap)
        .provideEnvironment(r)
    def createGroup(
        request: CreateGroupRequest
    ): IO[AwsError, zio.aws.xray.model.CreateGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.CreateGroupRequest,
        CreateGroupResponse
      ]("createGroup", api.createGroup)(request.buildAwsValue())
        .map(zio.aws.xray.model.CreateGroupResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.xray.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.xray.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.xray.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.xray.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def updateGroup(
        request: UpdateGroupRequest
    ): IO[AwsError, zio.aws.xray.model.UpdateGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.UpdateGroupRequest,
        UpdateGroupResponse
      ]("updateGroup", api.updateGroup)(request.buildAwsValue())
        .map(zio.aws.xray.model.UpdateGroupResponse.wrap)
        .provideEnvironment(r)
    def getTraceSummaries(
        request: GetTraceSummariesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly,
      zio.aws.xray.model.TraceSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest,
      GetTraceSummariesResponse,
      TraceSummary
    ](
      "getTraceSummaries",
      api.getTraceSummaries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.traceSummaries().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.xray.model.GetTraceSummariesResponse.wrap)
          .mapOutput(_.map(item => zio.aws.xray.model.TraceSummary.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getTraceSummariesPaginated(
        request: GetTraceSummariesRequest
    ): IO[AwsError, zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest,
        GetTraceSummariesResponse
      ]("getTraceSummaries", api.getTraceSummaries)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetTraceSummariesResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.xray.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.xray.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getGroup(
        request: GetGroupRequest
    ): IO[AwsError, zio.aws.xray.model.GetGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetGroupRequest,
        GetGroupResponse
      ]("getGroup", api.getGroup)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetGroupResponse.wrap)
        .provideEnvironment(r)
    def getInsight(request: GetInsightRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetInsightRequest,
        GetInsightResponse
      ]("getInsight", api.getInsight)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetInsightResponse.wrap)
        .provideEnvironment(r)
    def getEncryptionConfig(
        request: GetEncryptionConfigRequest
    ): IO[AwsError, zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetEncryptionConfigRequest,
        GetEncryptionConfigResponse
      ]("getEncryptionConfig", api.getEncryptionConfig)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetEncryptionConfigResponse.wrap)
        .provideEnvironment(r)
    def putTraceSegments(
        request: PutTraceSegmentsRequest
    ): IO[AwsError, zio.aws.xray.model.PutTraceSegmentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest,
        PutTraceSegmentsResponse
      ]("putTraceSegments", api.putTraceSegments)(request.buildAwsValue())
        .map(zio.aws.xray.model.PutTraceSegmentsResponse.wrap)
        .provideEnvironment(r)
    def getSamplingRules(
        request: GetSamplingRulesRequest
    ): ZStream[Any, AwsError, zio.aws.xray.model.SamplingRuleRecord.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest,
        GetSamplingRulesResponse,
        SamplingRuleRecord
      ](
        "getSamplingRules",
        api.getSamplingRules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.samplingRuleRecords().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.xray.model.SamplingRuleRecord.wrap(item))
        .provideEnvironment(r)
    def getSamplingRulesPaginated(
        request: GetSamplingRulesRequest
    ): IO[AwsError, zio.aws.xray.model.GetSamplingRulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest,
        GetSamplingRulesResponse
      ]("getSamplingRules", api.getSamplingRules)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetSamplingRulesResponse.wrap)
        .provideEnvironment(r)
    def getInsightSummaries(
        request: GetInsightSummariesRequest
    ): ZStream[Any, AwsError, zio.aws.xray.model.InsightSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest,
        GetInsightSummariesResponse,
        InsightSummary
      ](
        "getInsightSummaries",
        api.getInsightSummaries,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.insightSummaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.xray.model.InsightSummary.wrap(item))
        .provideEnvironment(r)
    def getInsightSummariesPaginated(
        request: GetInsightSummariesRequest
    ): IO[AwsError, zio.aws.xray.model.GetInsightSummariesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest,
        GetInsightSummariesResponse
      ]("getInsightSummaries", api.getInsightSummaries)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetInsightSummariesResponse.wrap)
        .provideEnvironment(r)
    def getGroups(
        request: GetGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.xray.model.GroupSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.xray.model.GetGroupsRequest,
        GetGroupsResponse,
        GroupSummary
      ](
        "getGroups",
        api.getGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.groups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.xray.model.GroupSummary.wrap(item))
        .provideEnvironment(r)
    def getGroupsPaginated(
        request: GetGroupsRequest
    ): IO[AwsError, zio.aws.xray.model.GetGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.xray.model.GetGroupsRequest,
        GetGroupsResponse
      ]("getGroups", api.getGroups)(request.buildAwsValue())
        .map(zio.aws.xray.model.GetGroupsResponse.wrap)
        .provideEnvironment(r)
  }
  def getInsightEvents(request: GetInsightEventsRequest): ZStream[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.InsightEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.getInsightEvents(request))
  def getInsightEventsPaginated(request: GetInsightEventsRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetInsightEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInsightEventsPaginated(request))
  def getServiceGraph(
      request: GetServiceGraphRequest
  ): ZIO[zio.aws.xray.XRay, AwsError, StreamingOutputResult[
    Any,
    zio.aws.xray.model.GetServiceGraphResponse.ReadOnly,
    zio.aws.xray.model.Service.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getServiceGraph(request))
  def getServiceGraphPaginated(request: GetServiceGraphRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetServiceGraphResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceGraphPaginated(request))
  def batchGetTraces(
      request: BatchGetTracesRequest
  ): ZStream[zio.aws.xray.XRay, AwsError, zio.aws.xray.model.Trace.ReadOnly] =
    ZStream.serviceWithStream(_.batchGetTraces(request))
  def batchGetTracesPaginated(request: BatchGetTracesRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.BatchGetTracesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetTracesPaginated(request))
  def getTimeSeriesServiceStatistics(
      request: GetTimeSeriesServiceStatisticsRequest
  ): ZIO[zio.aws.xray.XRay, AwsError, StreamingOutputResult[
    Any,
    zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly,
    zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getTimeSeriesServiceStatistics(request))
  def getTimeSeriesServiceStatisticsPaginated(
      request: GetTimeSeriesServiceStatisticsRequest
  ): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTimeSeriesServiceStatisticsPaginated(request))
  def deleteGroup(request: DeleteGroupRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.DeleteGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGroup(request))
  def getTraceGraph(
      request: GetTraceGraphRequest
  ): ZStream[zio.aws.xray.XRay, AwsError, zio.aws.xray.model.Service.ReadOnly] =
    ZStream.serviceWithStream(_.getTraceGraph(request))
  def getTraceGraphPaginated(request: GetTraceGraphRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetTraceGraphResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTraceGraphPaginated(request))
  def getSamplingStatisticSummaries(
      request: GetSamplingStatisticSummariesRequest
  ): ZStream[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.SamplingStatisticSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.getSamplingStatisticSummaries(request))
  def getSamplingStatisticSummariesPaginated(
      request: GetSamplingStatisticSummariesRequest
  ): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetSamplingStatisticSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSamplingStatisticSummariesPaginated(request))
  def putTelemetryRecords(request: PutTelemetryRecordsRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.PutTelemetryRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putTelemetryRecords(request))
  def createSamplingRule(request: CreateSamplingRuleRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.CreateSamplingRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSamplingRule(request))
  def updateSamplingRule(request: UpdateSamplingRuleRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.UpdateSamplingRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSamplingRule(request))
  def getInsightImpactGraph(
      request: GetInsightImpactGraphRequest
  ): ZIO[zio.aws.xray.XRay, AwsError, StreamingOutputResult[
    Any,
    zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly,
    zio.aws.xray.model.InsightImpactGraphService.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getInsightImpactGraph(request))
  def getInsightImpactGraphPaginated(
      request: GetInsightImpactGraphRequest
  ): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInsightImpactGraphPaginated(request))
  def deleteSamplingRule(request: DeleteSamplingRuleRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.DeleteSamplingRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSamplingRule(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getSamplingTargets(request: GetSamplingTargetsRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetSamplingTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSamplingTargets(request))
  def putEncryptionConfig(request: PutEncryptionConfigRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.PutEncryptionConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEncryptionConfig(request))
  def createGroup(request: CreateGroupRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.CreateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGroup(request))
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[zio.aws.xray.XRay, AwsError, zio.aws.xray.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def updateGroup(request: UpdateGroupRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.UpdateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGroup(request))
  def getTraceSummaries(
      request: GetTraceSummariesRequest
  ): ZIO[zio.aws.xray.XRay, AwsError, StreamingOutputResult[
    Any,
    zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly,
    zio.aws.xray.model.TraceSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getTraceSummaries(request))
  def getTraceSummariesPaginated(request: GetTraceSummariesRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTraceSummariesPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getGroup(request: GetGroupRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroup(request))
  def getInsight(
      request: GetInsightRequest
  ): ZIO[zio.aws.xray.XRay, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getInsight(request))
  def getEncryptionConfig(request: GetEncryptionConfigRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEncryptionConfig(request))
  def putTraceSegments(request: PutTraceSegmentsRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.PutTraceSegmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putTraceSegments(request))
  def getSamplingRules(request: GetSamplingRulesRequest): ZStream[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.SamplingRuleRecord.ReadOnly
  ] = ZStream.serviceWithStream(_.getSamplingRules(request))
  def getSamplingRulesPaginated(request: GetSamplingRulesRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetSamplingRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSamplingRulesPaginated(request))
  def getInsightSummaries(request: GetInsightSummariesRequest): ZStream[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.InsightSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.getInsightSummaries(request))
  def getInsightSummariesPaginated(request: GetInsightSummariesRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetInsightSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInsightSummariesPaginated(request))
  def getGroups(request: GetGroupsRequest): ZStream[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.getGroups(request))
  def getGroupsPaginated(request: GetGroupsRequest): ZIO[
    zio.aws.xray.XRay,
    AwsError,
    zio.aws.xray.model.GetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupsPaginated(request))
}
