package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Alias(
    name: Option[String] = None,
    names: Option[Iterable[String]] = None,
    `type`: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Alias = {
    import Alias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Alias
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Alias.ReadOnly =
    zio.aws.xray.model.Alias.wrap(buildAwsValue())
}
object Alias {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Alias] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Alias = zio.aws.xray.model.Alias(
      name.map(value => value),
      names.map(value => value),
      `type`.map(value => value)
    )
    def name: Option[String]
    def names: Option[List[String]]
    def `type`: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Alias
  ) extends zio.aws.xray.model.Alias.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val names: Option[List[String]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Alias
  ): zio.aws.xray.model.Alias.ReadOnly = new Wrapper(impl)
}
