package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{NullableBoolean, NullableDouble}
import scala.jdk.CollectionConverters._
final case class AnnotationValue(
    numberValue: Option[NullableDouble] = None,
    booleanValue: Option[NullableBoolean] = None,
    stringValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.AnnotationValue = {
    import AnnotationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.AnnotationValue
      .builder()
      .optionallyWith(numberValue.map(value => value: java.lang.Double))(
        _.numberValue
      )
      .optionallyWith(booleanValue.map(value => value: java.lang.Boolean))(
        _.booleanValue
      )
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.AnnotationValue.ReadOnly =
    zio.aws.xray.model.AnnotationValue.wrap(buildAwsValue())
}
object AnnotationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.AnnotationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.AnnotationValue =
      zio.aws.xray.model.AnnotationValue(
        numberValue.map(value => value),
        booleanValue.map(value => value),
        stringValue.map(value => value)
      )
    def numberValue: Option[NullableDouble]
    def booleanValue: Option[NullableBoolean]
    def stringValue: Option[String]
    def getNumberValue: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("numberValue", numberValue)
    def getBooleanValue: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.AnnotationValue
  ) extends zio.aws.xray.model.AnnotationValue.ReadOnly {
    override val numberValue: Option[NullableDouble] =
      scala.Option(impl.numberValue()).map(value => value: NullableDouble)
    override val booleanValue: Option[NullableBoolean] =
      scala.Option(impl.booleanValue()).map(value => value: NullableBoolean)
    override val stringValue: Option[String] =
      scala.Option(impl.stringValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.AnnotationValue
  ): zio.aws.xray.model.AnnotationValue.ReadOnly = new Wrapper(impl)
}
