package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnomalousService(
    serviceId: Option[zio.aws.xray.model.ServiceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.AnomalousService = {
    import AnomalousService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.AnomalousService
      .builder()
      .optionallyWith(serviceId.map(value => value.buildAwsValue()))(
        _.serviceId
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.AnomalousService.ReadOnly =
    zio.aws.xray.model.AnomalousService.wrap(buildAwsValue())
}
object AnomalousService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.AnomalousService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.AnomalousService = zio.aws.xray.model
      .AnomalousService(serviceId.map(value => value.asEditable))
    def serviceId: Option[zio.aws.xray.model.ServiceId.ReadOnly]
    def getServiceId
        : ZIO[Any, AwsError, zio.aws.xray.model.ServiceId.ReadOnly] =
      AwsError.unwrapOptionField("serviceId", serviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.AnomalousService
  ) extends zio.aws.xray.model.AnomalousService.ReadOnly {
    override val serviceId: Option[zio.aws.xray.model.ServiceId.ReadOnly] =
      scala
        .Option(impl.serviceId())
        .map(value => zio.aws.xray.model.ServiceId.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.AnomalousService
  ): zio.aws.xray.model.AnomalousService.ReadOnly = new Wrapper(impl)
}
