package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AvailabilityZoneDetail(name: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail = {
    import AvailabilityZoneDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly =
    zio.aws.xray.model.AvailabilityZoneDetail.wrap(buildAwsValue())
}
object AvailabilityZoneDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.AvailabilityZoneDetail =
      zio.aws.xray.model.AvailabilityZoneDetail(name.map(value => value))
    def name: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail
  ) extends zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail
  ): zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly = new Wrapper(impl)
}
