package zio.aws.xray.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class BackendConnectionErrors(
    timeoutCount: Option[NullableInteger] = None,
    connectionRefusedCount: Option[NullableInteger] = None,
    httpCode4XXCount: Option[NullableInteger] = None,
    httpCode5XXCount: Option[NullableInteger] = None,
    unknownHostCount: Option[NullableInteger] = None,
    otherCount: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.BackendConnectionErrors = {
    import BackendConnectionErrors.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.BackendConnectionErrors
      .builder()
      .optionallyWith(timeoutCount.map(value => value: Integer))(_.timeoutCount)
      .optionallyWith(connectionRefusedCount.map(value => value: Integer))(
        _.connectionRefusedCount
      )
      .optionallyWith(httpCode4XXCount.map(value => value: Integer))(
        _.httpCode4XXCount
      )
      .optionallyWith(httpCode5XXCount.map(value => value: Integer))(
        _.httpCode5XXCount
      )
      .optionallyWith(unknownHostCount.map(value => value: Integer))(
        _.unknownHostCount
      )
      .optionallyWith(otherCount.map(value => value: Integer))(_.otherCount)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.BackendConnectionErrors.ReadOnly =
    zio.aws.xray.model.BackendConnectionErrors.wrap(buildAwsValue())
}
object BackendConnectionErrors {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.BackendConnectionErrors
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.BackendConnectionErrors =
      zio.aws.xray.model.BackendConnectionErrors(
        timeoutCount.map(value => value),
        connectionRefusedCount.map(value => value),
        httpCode4XXCount.map(value => value),
        httpCode5XXCount.map(value => value),
        unknownHostCount.map(value => value),
        otherCount.map(value => value)
      )
    def timeoutCount: Option[NullableInteger]
    def connectionRefusedCount: Option[NullableInteger]
    def httpCode4XXCount: Option[NullableInteger]
    def httpCode5XXCount: Option[NullableInteger]
    def unknownHostCount: Option[NullableInteger]
    def otherCount: Option[NullableInteger]
    def getTimeoutCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("timeoutCount", timeoutCount)
    def getConnectionRefusedCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "connectionRefusedCount",
        connectionRefusedCount
      )
    def getHttpCode4XXCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("httpCode4XXCount", httpCode4XXCount)
    def getHttpCode5XXCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("httpCode5XXCount", httpCode5XXCount)
    def getUnknownHostCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("unknownHostCount", unknownHostCount)
    def getOtherCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("otherCount", otherCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.BackendConnectionErrors
  ) extends zio.aws.xray.model.BackendConnectionErrors.ReadOnly {
    override val timeoutCount: Option[NullableInteger] =
      scala.Option(impl.timeoutCount()).map(value => value: NullableInteger)
    override val connectionRefusedCount: Option[NullableInteger] = scala
      .Option(impl.connectionRefusedCount())
      .map(value => value: NullableInteger)
    override val httpCode4XXCount: Option[NullableInteger] =
      scala.Option(impl.httpCode4XXCount()).map(value => value: NullableInteger)
    override val httpCode5XXCount: Option[NullableInteger] =
      scala.Option(impl.httpCode5XXCount()).map(value => value: NullableInteger)
    override val unknownHostCount: Option[NullableInteger] =
      scala.Option(impl.unknownHostCount()).map(value => value: NullableInteger)
    override val otherCount: Option[NullableInteger] =
      scala.Option(impl.otherCount()).map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.BackendConnectionErrors
  ): zio.aws.xray.model.BackendConnectionErrors.ReadOnly = new Wrapper(impl)
}
