package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.TraceId
import scala.jdk.CollectionConverters._
final case class BatchGetTracesResponse(
    traces: Option[Iterable[zio.aws.xray.model.Trace]] = None,
    unprocessedTraceIds: Option[Iterable[TraceId]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.BatchGetTracesResponse = {
    import BatchGetTracesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.BatchGetTracesResponse
      .builder()
      .optionallyWith(
        traces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.traces)
      .optionallyWith(
        unprocessedTraceIds.map(value =>
          value.map { item =>
            TraceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.unprocessedTraceIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.BatchGetTracesResponse.ReadOnly =
    zio.aws.xray.model.BatchGetTracesResponse.wrap(buildAwsValue())
}
object BatchGetTracesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.BatchGetTracesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.BatchGetTracesResponse =
      zio.aws.xray.model.BatchGetTracesResponse(
        traces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedTraceIds.map(value => value),
        nextToken.map(value => value)
      )
    def traces: Option[List[zio.aws.xray.model.Trace.ReadOnly]]
    def unprocessedTraceIds: Option[List[TraceId]]
    def nextToken: Option[String]
    def getTraces: ZIO[Any, AwsError, List[zio.aws.xray.model.Trace.ReadOnly]] =
      AwsError.unwrapOptionField("traces", traces)
    def getUnprocessedTraceIds: ZIO[Any, AwsError, List[TraceId]] =
      AwsError.unwrapOptionField("unprocessedTraceIds", unprocessedTraceIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.BatchGetTracesResponse
  ) extends zio.aws.xray.model.BatchGetTracesResponse.ReadOnly {
    override val traces: Option[List[zio.aws.xray.model.Trace.ReadOnly]] = scala
      .Option(impl.traces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.Trace.wrap(item)
        }.toList
      )
    override val unprocessedTraceIds: Option[List[TraceId]] = scala
      .Option(impl.unprocessedTraceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.primitives.TraceId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.BatchGetTracesResponse
  ): zio.aws.xray.model.BatchGetTracesResponse.ReadOnly = new Wrapper(impl)
}
