package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateGroupResponse(
    group: Option[zio.aws.xray.model.Group] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.CreateGroupResponse = {
    import CreateGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.CreateGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.CreateGroupResponse.ReadOnly =
    zio.aws.xray.model.CreateGroupResponse.wrap(buildAwsValue())
}
object CreateGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.CreateGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.CreateGroupResponse = zio.aws.xray.model
      .CreateGroupResponse(group.map(value => value.asEditable))
    def group: Option[zio.aws.xray.model.Group.ReadOnly]
    def getGroup: ZIO[Any, AwsError, zio.aws.xray.model.Group.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.CreateGroupResponse
  ) extends zio.aws.xray.model.CreateGroupResponse.ReadOnly {
    override val group: Option[zio.aws.xray.model.Group.ReadOnly] = scala
      .Option(impl.group())
      .map(value => zio.aws.xray.model.Group.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.CreateGroupResponse
  ): zio.aws.xray.model.CreateGroupResponse.ReadOnly = new Wrapper(impl)
}
