package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSamplingRuleResponse(
    samplingRuleRecord: Option[zio.aws.xray.model.SamplingRuleRecord] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.CreateSamplingRuleResponse = {
    import CreateSamplingRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.CreateSamplingRuleResponse
      .builder()
      .optionallyWith(samplingRuleRecord.map(value => value.buildAwsValue()))(
        _.samplingRuleRecord
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.CreateSamplingRuleResponse.ReadOnly =
    zio.aws.xray.model.CreateSamplingRuleResponse.wrap(buildAwsValue())
}
object CreateSamplingRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.CreateSamplingRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.CreateSamplingRuleResponse =
      zio.aws.xray.model.CreateSamplingRuleResponse(
        samplingRuleRecord.map(value => value.asEditable)
      )
    def samplingRuleRecord
        : Option[zio.aws.xray.model.SamplingRuleRecord.ReadOnly]
    def getSamplingRuleRecord
        : ZIO[Any, AwsError, zio.aws.xray.model.SamplingRuleRecord.ReadOnly] =
      AwsError.unwrapOptionField("samplingRuleRecord", samplingRuleRecord)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.CreateSamplingRuleResponse
  ) extends zio.aws.xray.model.CreateSamplingRuleResponse.ReadOnly {
    override val samplingRuleRecord
        : Option[zio.aws.xray.model.SamplingRuleRecord.ReadOnly] = scala
      .Option(impl.samplingRuleRecord())
      .map(value => zio.aws.xray.model.SamplingRuleRecord.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.CreateSamplingRuleResponse
  ): zio.aws.xray.model.CreateSamplingRuleResponse.ReadOnly = new Wrapper(impl)
}
