package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteSamplingRuleRequest(
    ruleName: Option[String] = None,
    ruleARN: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest = {
    import DeleteSamplingRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest
      .builder()
      .optionallyWith(ruleName.map(value => value: java.lang.String))(
        _.ruleName
      )
      .optionallyWith(ruleARN.map(value => value: java.lang.String))(_.ruleARN)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.DeleteSamplingRuleRequest.ReadOnly =
    zio.aws.xray.model.DeleteSamplingRuleRequest.wrap(buildAwsValue())
}
object DeleteSamplingRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.DeleteSamplingRuleRequest =
      zio.aws.xray.model.DeleteSamplingRuleRequest(
        ruleName.map(value => value),
        ruleARN.map(value => value)
      )
    def ruleName: Option[String]
    def ruleARN: Option[String]
    def getRuleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getRuleARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleARN", ruleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest
  ) extends zio.aws.xray.model.DeleteSamplingRuleRequest.ReadOnly {
    override val ruleName: Option[String] =
      scala.Option(impl.ruleName()).map(value => value: String)
    override val ruleARN: Option[String] =
      scala.Option(impl.ruleARN()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest
  ): zio.aws.xray.model.DeleteSamplingRuleRequest.ReadOnly = new Wrapper(impl)
}
