package zio.aws.xray.model
import java.time.Instant
import zio.aws.xray.model.primitives.{Timestamp, NullableInteger}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Edge(
    referenceId: Option[NullableInteger] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    summaryStatistics: Option[zio.aws.xray.model.EdgeStatistics] = None,
    responseTimeHistogram: Option[Iterable[zio.aws.xray.model.HistogramEntry]] =
      None,
    aliases: Option[Iterable[zio.aws.xray.model.Alias]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Edge = {
    import Edge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Edge
      .builder()
      .optionallyWith(referenceId.map(value => value: Integer))(_.referenceId)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(summaryStatistics.map(value => value.buildAwsValue()))(
        _.summaryStatistics
      )
      .optionallyWith(
        responseTimeHistogram.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responseTimeHistogram)
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Edge.ReadOnly =
    zio.aws.xray.model.Edge.wrap(buildAwsValue())
}
object Edge {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Edge] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Edge = zio.aws.xray.model.Edge(
      referenceId.map(value => value),
      startTime.map(value => value),
      endTime.map(value => value),
      summaryStatistics.map(value => value.asEditable),
      responseTimeHistogram.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      aliases.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def referenceId: Option[NullableInteger]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def summaryStatistics: Option[zio.aws.xray.model.EdgeStatistics.ReadOnly]
    def responseTimeHistogram
        : Option[List[zio.aws.xray.model.HistogramEntry.ReadOnly]]
    def aliases: Option[List[zio.aws.xray.model.Alias.ReadOnly]]
    def getReferenceId: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSummaryStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.EdgeStatistics.ReadOnly] =
      AwsError.unwrapOptionField("summaryStatistics", summaryStatistics)
    def getResponseTimeHistogram
        : ZIO[Any, AwsError, List[zio.aws.xray.model.HistogramEntry.ReadOnly]] =
      AwsError.unwrapOptionField("responseTimeHistogram", responseTimeHistogram)
    def getAliases
        : ZIO[Any, AwsError, List[zio.aws.xray.model.Alias.ReadOnly]] =
      AwsError.unwrapOptionField("aliases", aliases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Edge
  ) extends zio.aws.xray.model.Edge.ReadOnly {
    override val referenceId: Option[NullableInteger] =
      scala.Option(impl.referenceId()).map(value => value: NullableInteger)
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val summaryStatistics
        : Option[zio.aws.xray.model.EdgeStatistics.ReadOnly] = scala
      .Option(impl.summaryStatistics())
      .map(value => zio.aws.xray.model.EdgeStatistics.wrap(value))
    override val responseTimeHistogram
        : Option[List[zio.aws.xray.model.HistogramEntry.ReadOnly]] = scala
      .Option(impl.responseTimeHistogram())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.HistogramEntry.wrap(item)
        }.toList
      )
    override val aliases: Option[List[zio.aws.xray.model.Alias.ReadOnly]] =
      scala
        .Option(impl.aliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.Alias.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Edge
  ): zio.aws.xray.model.Edge.ReadOnly = new Wrapper(impl)
}
