package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EncryptionConfig(
    keyId: Option[String] = None,
    status: Option[zio.aws.xray.model.EncryptionStatus] = None,
    `type`: Option[zio.aws.xray.model.EncryptionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.EncryptionConfig = {
    import EncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.EncryptionConfig
      .builder()
      .optionallyWith(keyId.map(value => value: java.lang.String))(_.keyId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.EncryptionConfig.ReadOnly =
    zio.aws.xray.model.EncryptionConfig.wrap(buildAwsValue())
}
object EncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.EncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.EncryptionConfig =
      zio.aws.xray.model.EncryptionConfig(
        keyId.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def keyId: Option[String]
    def status: Option[zio.aws.xray.model.EncryptionStatus]
    def `type`: Option[zio.aws.xray.model.EncryptionType]
    def getKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getStatus: ZIO[Any, AwsError, zio.aws.xray.model.EncryptionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.xray.model.EncryptionType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.EncryptionConfig
  ) extends zio.aws.xray.model.EncryptionConfig.ReadOnly {
    override val keyId: Option[String] =
      scala.Option(impl.keyId()).map(value => value: String)
    override val status: Option[zio.aws.xray.model.EncryptionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.xray.model.EncryptionStatus.wrap(value))
    override val `type`: Option[zio.aws.xray.model.EncryptionType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.xray.model.EncryptionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.EncryptionConfig
  ): zio.aws.xray.model.EncryptionConfig.ReadOnly = new Wrapper(impl)
}
